/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.manual.segment;

import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import li.cil.tis3d.client.manual.Document;
import li.cil.tis3d.client.manual.segment.BasicTextSegment;
import li.cil.tis3d.client.manual.segment.InteractiveSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import li.cil.tis3d.client.manual.segment.SegmentRefiner;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;

public class TextSegment
extends BasicTextSegment {
    private final Segment parent;
    private final String text;

    public TextSegment(Segment parent, String text) {
        this.parent = parent;
        this.text = text;
    }

    @Override
    public Segment parent() {
        return this.parent;
    }

    @Override
    protected String text() {
        return this.text;
    }

    @Override
    public Optional<InteractiveSegment> render(int x, int y, int indent, int maxWidth, FontRenderer renderer, int mouseX, int mouseY) {
        int currentX = x + indent;
        int currentY = y;
        String chars = this.text;
        if (indent == 0) {
            chars = chars.substring(TextSegment.indexOfFirstNonWhitespace(chars));
        }
        int wrapIndent = this.computeWrapIndent(renderer);
        int numChars = this.maxChars(chars, maxWidth - indent, maxWidth - wrapIndent, renderer);
        Optional<InteractiveSegment> hovered = Optional.empty();
        float scale = this.resolvedScale();
        String format = this.resolvedFormat();
        int color = this.resolvedColor();
        Optional<InteractiveSegment> interactive = this.resolvedInteractive();
        while (chars.length() > 0) {
            String part = chars.substring(0, numChars);
            if (!hovered.isPresent()) {
                int cx = currentX;
                int cy = currentY;
                hovered = interactive.flatMap(segment -> segment.checkHovered(mouseX, mouseY, cx, cy, this.stringWidth(part, renderer), (int)((float)Document.lineHeight(renderer) * scale)));
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)currentX, (float)currentY, (float)0.0f);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)(-currentX), (float)(-currentY), (float)0.0f);
            renderer.func_78276_b(format + part, currentX, currentY, color);
            GL11.glPopMatrix();
            currentX = x + wrapIndent;
            currentY += this.lineHeight(renderer);
            chars = chars.substring(numChars);
            chars = chars.substring(TextSegment.indexOfFirstNonWhitespace(chars));
            numChars = this.maxChars(chars, maxWidth - wrapIndent, maxWidth - wrapIndent, renderer);
        }
        return hovered;
    }

    @Override
    public Iterable<Segment> refine(Pattern pattern, SegmentRefiner factory) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        int textStart = 0;
        Matcher matcher = pattern.matcher(this.text);
        while (matcher.find()) {
            if (matcher.start() > textStart) {
                result.add(new TextSegment(this, this.text.substring(textStart, matcher.start())));
            }
            textStart = matcher.end();
            result.add(factory.refine(this, matcher));
        }
        if (textStart == 0) {
            result.add(this);
        } else if (textStart < this.text.length()) {
            result.add(new TextSegment(this, this.text.substring(textStart)));
        }
        return result;
    }

    @Override
    protected int lineHeight(FontRenderer renderer) {
        return (int)((float)super.lineHeight(renderer) * this.resolvedScale());
    }

    @Override
    protected int stringWidth(String s, FontRenderer renderer) {
        return (int)((float)renderer.func_78256_a(this.resolvedFormat() + s) * this.resolvedScale());
    }

    protected Optional<Integer> color() {
        return Optional.empty();
    }

    protected Optional<Float> scale() {
        return Optional.empty();
    }

    protected String format() {
        return "";
    }

    private int resolvedColor() {
        return this.color().orElseGet(this::parentColor);
    }

    private int parentColor() {
        Segment parent = this.parent();
        if (parent instanceof TextSegment) {
            return ((TextSegment)parent).resolvedColor();
        }
        return 0x333333;
    }

    private float resolvedScale() {
        return this.scale().orElseGet(this::parentScale).floatValue();
    }

    private float parentScale() {
        Segment parent = this.parent();
        if (parent instanceof TextSegment) {
            return this.scale().orElse(Float.valueOf(1.0f)).floatValue() * ((TextSegment)parent).resolvedScale();
        }
        return 1.0f;
    }

    private String resolvedFormat() {
        Segment parent = this.parent();
        if (parent instanceof TextSegment) {
            return ((TextSegment)parent).resolvedFormat() + this.format();
        }
        return this.format();
    }

    private Optional<InteractiveSegment> resolvedInteractive() {
        if (this instanceof InteractiveSegment) {
            return Optional.of((InteractiveSegment)((Object)this));
        }
        if (this.parent() instanceof TextSegment) {
            return ((TextSegment)this.parent()).resolvedInteractive();
        }
        return Optional.empty();
    }
}

