/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.model.obj;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import li.cil.tis3d.client.model.obj.OBJModel;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public enum OBJLoader implements ICustomModelLoader
{
    INSTANCE;

    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, OBJModel> cache = new HashMap<ResourceLocation, OBJModel>();
    private final Map<ResourceLocation, Exception> errors = new HashMap<ResourceLocation, Exception>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        FMLLog.log((Level)Level.INFO, (String)"OBJLoader: Domain %s has been added.", (Object[])new Object[]{domain.toLowerCase()});
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
        this.errors.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        OBJModel model;
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        if (!this.cache.containsKey(file)) {
            IResource resource = null;
            try {
                resource = this.manager.func_110536_a(file);
            }
            catch (FileNotFoundException e) {
                if (modelLocation.func_110623_a().startsWith("models/block/")) {
                    resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/item/" + file.func_110623_a().substring("models/block/".length())));
                }
                if (modelLocation.func_110623_a().startsWith("models/item/")) {
                    resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/block/" + file.func_110623_a().substring("models/item/".length())));
                }
                throw e;
            }
            OBJModel.Parser parser = new OBJModel.Parser(resource, this.manager);
            OBJModel model2 = null;
            try {
                model2 = parser.parse();
            }
            catch (Exception e) {
                this.errors.put(modelLocation, e);
            }
            finally {
                this.cache.put(modelLocation, model2);
            }
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + file, (Throwable)this.errors.get(modelLocation));
        }
        return model;
    }
}

