/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.render.font;

import java.util.stream.IntStream;
import li.cil.tis3d.client.render.font.FontRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractFontRenderer
implements FontRenderer {
    private final int[] CHAR_MAP = IntStream.range(0, 256).map(this.getCharacters()::indexOf).toArray();
    private final int COLUMNS = this.getResolution() / (this.getCharWidth() + this.getGapU());
    private final float U_SIZE = (float)this.getCharWidth() / (float)this.getResolution();
    private final float V_SIZE = (float)this.getCharHeight() / (float)this.getResolution();
    private final float U_STEP = (float)(this.getCharWidth() + this.getGapU()) / (float)this.getResolution();
    private final float V_STEP = (float)(this.getCharHeight() + this.getGapV()) / (float)this.getResolution();

    @Override
    public void drawString(String value) {
        this.drawString(value, value.length());
    }

    @Override
    public void drawString(String value, int maxChars) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a((boolean)false);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTextureLocation());
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float tx = 0.0f;
        int end = Math.min(maxChars, value.length());
        for (int i = 0; i < end; ++i) {
            char ch = value.charAt(i);
            this.drawChar(tx, ch, buffer);
            tx += (float)(this.getCharWidth() + this.getGapU());
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected abstract String getCharacters();

    protected abstract ResourceLocation getTextureLocation();

    protected abstract int getResolution();

    protected abstract int getGapU();

    protected abstract int getGapV();

    private void drawChar(float x, char ch, VertexBuffer buffer) {
        if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
            return;
        }
        int index = this.getCharIndex(ch);
        int column = index % this.COLUMNS;
        int row = index / this.COLUMNS;
        float u = (float)column * this.U_STEP;
        float v = (float)row * this.V_STEP;
        buffer.func_181662_b((double)x, (double)this.getCharHeight(), 0.0).func_187315_a((double)u, (double)(v + this.V_SIZE)).func_181675_d();
        buffer.func_181662_b((double)(x + (float)this.getCharWidth()), (double)this.getCharHeight(), 0.0).func_187315_a((double)(u + this.U_SIZE), (double)(v + this.V_SIZE)).func_181675_d();
        buffer.func_181662_b((double)(x + (float)this.getCharWidth()), 0.0, 0.0).func_187315_a((double)(u + this.U_SIZE), (double)v).func_181675_d();
        buffer.func_181662_b((double)x, 0.0, 0.0).func_187315_a((double)u, (double)v).func_181675_d();
    }

    private int getCharIndex(char ch) {
        if (ch >= this.CHAR_MAP.length) {
            return this.CHAR_MAP[63];
        }
        int index = this.CHAR_MAP[ch];
        if (index < 0) {
            return this.CHAR_MAP[63];
        }
        return index;
    }
}

