/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.render.tile;

import java.util.HashSet;
import java.util.Set;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.render.TextureLoader;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public final class TileEntitySpecialRendererCasing
extends TileEntitySpecialRenderer<TileEntityCasing> {
    private static final Set<Class<?>> BLACKLIST = new HashSet();

    public void renderTileEntityAt(TileEntityCasing casing, double x, double y, double z, float partialTicks, int destroyStage) {
        double dx = x + 0.5;
        double dy = y + 0.5;
        double dz = z + 0.5;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)dx, (double)dy, (double)dz);
        RenderHelper.func_74518_a();
        for (Face face : Face.VALUES) {
            if (this.isRenderingBackFace(face, dx, dy, dz)) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            this.setupMatrix(face);
            this.ensureSanity(casing, face);
            if (this.isPlayerHoldingKey()) {
                this.drawLockOverlay(casing);
            } else {
                this.drawModuleOverlay(casing, face, partialTicks);
            }
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private boolean isRenderingBackFace(Face face, double dx, double dy, double dz) {
        EnumFacing facing = Face.toEnumFacing(face.getOpposite());
        double dotProduct = (double)facing.func_82601_c() * dx + (double)facing.func_96559_d() * (dy - (double)Minecraft.func_71410_x().field_71439_g.func_70047_e()) + (double)facing.func_82599_e() * dz;
        return dotProduct < 0.0;
    }

    private void setupMatrix(Face face) {
        switch (face) {
            case Y_NEG: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Y_POS: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Z_NEG: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case Z_POS: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case X_NEG: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case X_POS: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)-0.505);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    private void ensureSanity(TileEntityCasing casing, Face face) {
        GlStateManager.func_179098_w();
        int brightness = this.func_178459_a().func_175626_b(casing.getPosition().func_177972_a(Face.toEnumFacing(face)), 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(brightness % 65536), (float)(brightness / 65536));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawLockOverlay(TileEntityCasing casing) {
        if (!this.isPlayerKindaClose(casing)) {
            return;
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        RenderUtil.bindTexture(TextureMap.field_110575_b);
        TextureAtlasSprite icon = casing.isLocked() ? Minecraft.func_71410_x().func_147117_R().func_110572_b(TextureLoader.LOCATION_CASING_LOCKED_OVERLAY.toString()) : Minecraft.func_71410_x().func_147117_R().func_110572_b(TextureLoader.LOCATION_CASING_UNLOCKED_OVERLAY.toString());
        RenderUtil.drawQuad(icon.func_94209_e(), icon.func_94206_g(), icon.func_94212_f(), icon.func_94210_h());
    }

    private void drawModuleOverlay(TileEntityCasing casing, Face face, float partialTicks) {
        Module module = casing.getModule(face);
        if (module == null) {
            return;
        }
        if (BLACKLIST.contains(module.getClass())) {
            return;
        }
        try {
            module.render(casing.isEnabled(), partialTicks);
        }
        catch (Exception e) {
            BLACKLIST.add(module.getClass());
            TIS3D.getLog().error("A module threw an exception while rendering, won't render again!", (Throwable)e);
        }
    }

    private boolean isPlayerKindaClose(TileEntityCasing casing) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return player.func_174831_c(casing.func_174877_v()) < 256.0;
    }

    private boolean isPlayerHoldingKey() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return Items.isKey(player.func_184586_b(EnumHand.MAIN_HAND));
    }
}

