/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common;

import java.util.function.Supplier;
import li.cil.tis3d.api.API;
import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.api.ModuleAPI;
import li.cil.tis3d.api.prefab.manual.ResourceContentProvider;
import li.cil.tis3d.client.manual.provider.GameRegistryPathProvider;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.api.CreativeTab;
import li.cil.tis3d.common.api.FontRendererAPIImpl;
import li.cil.tis3d.common.api.InfraredAPIImpl;
import li.cil.tis3d.common.api.ManualAPIImpl;
import li.cil.tis3d.common.api.ModuleAPIImpl;
import li.cil.tis3d.common.api.SerialAPIImpl;
import li.cil.tis3d.common.capabilities.CapabilityInfraredReceiver;
import li.cil.tis3d.common.entity.EntityInfraredPacket;
import li.cil.tis3d.common.event.TickHandlerInfraredPacket;
import li.cil.tis3d.common.init.Blocks;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.integration.Integration;
import li.cil.tis3d.common.integration.redstone.RedstoneIntegration;
import li.cil.tis3d.common.item.ItemModule;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.provider.ModuleProviderAudio;
import li.cil.tis3d.common.provider.ModuleProviderBundledRedstone;
import li.cil.tis3d.common.provider.ModuleProviderDisplay;
import li.cil.tis3d.common.provider.ModuleProviderExecution;
import li.cil.tis3d.common.provider.ModuleProviderInfrared;
import li.cil.tis3d.common.provider.ModuleProviderKeypad;
import li.cil.tis3d.common.provider.ModuleProviderRandom;
import li.cil.tis3d.common.provider.ModuleProviderRandomAccessMemory;
import li.cil.tis3d.common.provider.ModuleProviderRedstone;
import li.cil.tis3d.common.provider.ModuleProviderSerialPort;
import li.cil.tis3d.common.provider.ModuleProviderStack;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class ProxyCommon {
    public void onPreInit(FMLPreInitializationEvent event) {
        Settings.load(event.getSuggestedConfigurationFile());
        API.creativeTab = new CreativeTab();
        API.fontRendererAPI = new FontRendererAPIImpl();
        API.infraredAPI = new InfraredAPIImpl();
        API.manualAPI = ManualAPIImpl.INSTANCE;
        API.moduleAPI = new ModuleAPIImpl();
        API.serialAPI = SerialAPIImpl.INSTANCE;
        CapabilityInfraredReceiver.register();
        Blocks.registerBlocks(this);
        Items.register(this);
        Integration.preInit(event);
    }

    public void onInit(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"book", (Item)Items.bookCode);
        OreDictionary.registerOre((String)"book", (Item)Items.bookManual);
        for (String module : Constants.MODULES) {
            ProxyCommon.registerModuleOre(module);
        }
        Blocks.addRecipes();
        Items.addRecipes();
        EntityRegistry.registerModEntity(EntityInfraredPacket.class, (String)"tis3d:infraredPacket", (int)1, (Object)TIS3D.instance, (int)16, (int)1, (boolean)true);
        Network.INSTANCE.init();
        MinecraftForge.EVENT_BUS.register((Object)Network.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RedstoneIntegration.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TickHandlerInfraredPacket.INSTANCE);
        ModuleAPI.addProvider(new ModuleProviderAudio());
        ModuleAPI.addProvider(new ModuleProviderBundledRedstone());
        ModuleAPI.addProvider(new ModuleProviderDisplay());
        ModuleAPI.addProvider(new ModuleProviderExecution());
        ModuleAPI.addProvider(new ModuleProviderInfrared());
        ModuleAPI.addProvider(new ModuleProviderKeypad());
        ModuleAPI.addProvider(new ModuleProviderSerialPort());
        ModuleAPI.addProvider(new ModuleProviderStack());
        ModuleAPI.addProvider(new ModuleProviderRandom());
        ModuleAPI.addProvider(new ModuleProviderRandomAccessMemory());
        ModuleAPI.addProvider(new ModuleProviderRedstone());
        ManualAPI.addProvider(new GameRegistryPathProvider());
        ManualAPI.addProvider(new ResourceContentProvider("tis3d", "doc/"));
        ManualAPI.addProvider(SerialAPIImpl.INSTANCE.getSerialProtocolContentProvider());
        Integration.init(event);
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        Integration.postInit(event);
    }

    public Block registerBlock(String name, Supplier<Block> constructor, Class<? extends TileEntity> tileEntity) {
        Block block = (Block)constructor.get().func_149711_c(5.0f).func_149752_b(10.0f).func_149663_c("tis3d." + name).func_149647_a((CreativeTabs)API.creativeTab).setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.registerTileEntity(tileEntity, (String)name);
        Item itemBlock = (Item)new ItemBlock(block).setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        return block;
    }

    public Item registerItem(String name, Supplier<Item> constructor) {
        Item item = (Item)constructor.get().func_77655_b("tis3d." + name).func_77637_a((CreativeTabs)API.creativeTab).setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)item);
        return item;
    }

    public Item registerModule(String name) {
        if (Settings.disabledModules.contains(name)) {
            return null;
        }
        return this.registerItem(name, ItemModule::new);
    }

    private static void registerModuleOre(String name) {
        if (Settings.disabledModules.contains(name)) {
            return;
        }
        OreDictionary.registerOre((String)"tis3d:module", (Item)((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("tis3d", name))));
    }
}

