/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import li.cil.tis3d.common.Constants;
import net.minecraftforge.common.config.Configuration;

public final class Settings {
    public static int maxPacketsPerTick = 10;
    public static int maxParticlesPerTick = 5;
    public static int maxCasingsPerController = 8;
    public static int maxLinesPerProgram = 20;
    public static int maxColumnsPerLine = 18;
    public static int maxInfraredQueueLength = 16;
    public static final Set<String> disabledModules = new HashSet<String>();

    public static void load(File configFile) {
        Configuration config = new Configuration(configFile);
        config.load();
        maxPacketsPerTick = config.getInt("maxPacketsPerTick", "network", maxPacketsPerTick, 1, 500, "The maximum number of status packets modules may send per tick. When this is exceeded, throttling kicks in.");
        maxParticlesPerTick = config.getInt("maxParticlesPerTick", "network", maxParticlesPerTick, 1, 500, "The maximum number of particle effects data transfer may trigger per tick. When this is exceeded, throttling kicks in.");
        maxCasingsPerController = config.getInt("maxCasings", "controller", maxCasingsPerController, 1, 512, "The maximum number of casings a single controller supports.");
        maxLinesPerProgram = config.getInt("maxLinesPerProgram", "module.execution", maxLinesPerProgram, 1, 200, "The maximum number of lines an ASM program for an execution node may have.");
        maxColumnsPerLine = config.getInt("maxColumnsPerLine", "module.execution", maxColumnsPerLine, 1, 80, "The maximum number of columns per line of an ASM program for an execution node may have.");
        maxInfraredQueueLength = config.getInt("maxQueueLength", "module.infrared", maxInfraredQueueLength, 1, 64, "The maximum number of infrared packets that can be stored in the receiver's buffer.");
        disabledModules.clear();
        int prefixLength = "module*".length();
        for (String module : Constants.MODULES) {
            String name = String.valueOf(module.charAt(prefixLength - 1)).toLowerCase() + module.substring(prefixLength);
            Settings.checkModule(config, "module." + name, module);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void checkModule(Configuration config, String path, String name) {
        if (!config.getBoolean("enabled", path, true, "Whether the module is enabled. Disabled modules are not registered, meaning if you disable them later on the items will disappear!")) {
            disabledModules.add(name);
        }
    }

    private Settings() {
    }
}

