/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.api.module.traits.Rotatable;
import li.cil.tis3d.client.model.obj.OBJModel;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.item.ItemBookManual;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import li.cil.tis3d.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public final class BlockCasing
extends Block {
    private static final OBJModel.OBJState[] OBJ_STATE_CACHE = new OBJModel.OBJState[1 << Face.VALUES.length];
    private static final List<String> VISIBLE_GROUPS = new ArrayList<String>(6);
    private static final String[] FACE_TO_GROUP = new String[]{"casing:module.Y_NEG", "casing:module.Y_POS", "casing:module.Z_NEG", "casing:module.Z_POS", "casing:module.X_NEG", "casing:module.X_POS"};

    public BlockCasing() {
        super(Material.field_151573_f);
    }

    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState baseState = (IExtendedBlockState)state;
        TileEntity tileEntity = world.func_175625_s(pos);
        int mask = this.packVisibility(tileEntity);
        return baseState.withProperty((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE, (Object)this.getCachedObjState(mask));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OBJModel.OBJState getCachedObjState(int mask) {
        OBJModel.OBJState[] oBJStateArray = OBJ_STATE_CACHE;
        synchronized (OBJ_STATE_CACHE) {
            if (OBJ_STATE_CACHE[mask] == null) {
                VISIBLE_GROUPS.clear();
                VISIBLE_GROUPS.add("casing:casing");
                for (Face face : Face.VALUES) {
                    if ((mask & 1 << face.ordinal()) == 0) continue;
                    VISIBLE_GROUPS.add(FACE_TO_GROUP[face.ordinal()]);
                }
                BlockCasing.OBJ_STATE_CACHE[mask] = new OBJModel.OBJState(VISIBLE_GROUPS, true);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return OBJ_STATE_CACHE[mask];
        }
    }

    private int packVisibility(@Nullable TileEntity tileEntity) {
        int mask = 0;
        if (tileEntity instanceof TileEntityCasing) {
            TileEntityCasing casing = (TileEntityCasing)tileEntity;
            for (Face face : Face.VALUES) {
                if (casing.getModule(face) == null) continue;
                mask |= 1 << face.ordinal();
            }
        }
        return mask;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityCasing casing;
        ItemStack stack;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCasing && (stack = (casing = (TileEntityCasing)tileEntity).func_70301_a(target.field_178784_b.ordinal())) != null) {
            return stack.func_77946_l();
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCasing();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (world.func_175667_e(pos) && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityCasing) {
            ItemStack moduleStack;
            TileEntityCasing casing = (TileEntityCasing)tileEntity;
            if (Items.isKey(heldItem)) {
                if (!world.field_72995_K) {
                    if (casing.isLocked()) {
                        casing.unlock(heldItem);
                    } else {
                        casing.lock(heldItem);
                    }
                }
                return true;
            }
            if (Items.isBookManual(heldItem) && ItemBookManual.tryOpenManual(world, player, ManualAPI.pathFor(moduleStack = casing.func_70301_a(side.ordinal())))) {
                return true;
            }
            Module module = casing.getModule(Face.fromEnumFacing(side));
            if (module != null && module.onActivate(player, hand, heldItem, hitX, hitY, hitZ)) {
                return true;
            }
            if (casing.isLocked()) {
                return true;
            }
            ItemStack oldModule = casing.func_70301_a(side.ordinal());
            if (oldModule != null) {
                EntityItem entity;
                if (!world.field_72995_K && (entity = InventoryUtils.drop(world, pos, casing, side.ordinal(), 1, side)) != null) {
                    entity.func_174868_q();
                    entity.func_70100_b_(player);
                    world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.2f, 0.8f + world.field_73012_v.nextFloat() * 0.1f);
                }
                return true;
            }
            if (heldItem != null && casing.func_180462_a(side.ordinal(), heldItem, side)) {
                if (!world.field_72995_K) {
                    Face face;
                    Module newModule;
                    if (player.field_71075_bZ.field_75098_d) {
                        casing.func_70299_a(side.ordinal(), heldItem.func_77946_l().func_77979_a(1));
                    } else {
                        casing.func_70299_a(side.ordinal(), heldItem.func_77979_a(1));
                    }
                    if (side.func_176740_k() == EnumFacing.Axis.Y && (newModule = casing.getModule(face = Face.fromEnumFacing(side))) instanceof Rotatable) {
                        Port orientation = Port.fromEnumFacing(player.func_174811_aO());
                        ((Rotatable)newModule).setFacing(orientation);
                    }
                    world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.2f, 0.8f + world.field_73012_v.nextFloat() * 0.1f);
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityCasing) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityCasing)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityCasing casing;
        Module module;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityCasing && (module = (casing = (TileEntityCasing)tileentity).getModule(Face.fromEnumFacing(side.func_176734_d()))) instanceof Redstone) {
            return ((Redstone)module).getRedstoneOutput();
        }
        return super.func_180656_a(blockState, world, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCasing) {
            TileEntityCasing casing = (TileEntityCasing)tileEntity;
            casing.checkNeighbors();
            casing.notifyModulesOfBlockChange(neighborBlock);
            casing.markRedstoneDirty();
        }
        super.func_189540_a(state, world, pos, neighborBlock);
    }
}

