/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.entity;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.common.capabilities.CapabilityInfraredReceiver;
import li.cil.tis3d.common.event.TickHandlerInfraredPacket;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageParticleEffect;
import li.cil.tis3d.util.Raytracing;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EntityInfraredPacket
extends Entity
implements InfraredPacket {
    private static final float TRAVEL_SPEED = 24.0f;
    private static final int DEFAULT_LIFETIME = 2;
    private static final String TAG_VALUE = "value";
    private static final String TAG_LIFETIME = "lifetime";
    private static final DataParameter<Integer> DATA_VALUE = EntityDataManager.func_187226_a(EntityInfraredPacket.class, (DataSerializer)DataSerializers.field_187192_b);
    private int lifetime;
    private short value;

    public EntityInfraredPacket(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.25f, 0.25f);
    }

    public void configure(Vec3d start, Vec3d direction, short value) {
        this.func_70107_b(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        this.field_70159_w = direction.field_72450_a * 24.0;
        this.field_70181_x = direction.field_72448_b * 24.0;
        this.field_70179_y = direction.field_72449_c * 24.0;
        this.lifetime = 2;
        this.value = value;
        this.func_184212_Q().func_187227_b(DATA_VALUE, (Object)(value & 0xFFFF));
    }

    public void updateLifetime() {
        if (this.lifetime-- < 1) {
            this.func_70106_y();
        }
    }

    private void revive() {
        this.field_70128_L = false;
        if (!this.func_130014_f_().field_72995_K) {
            TickHandlerInfraredPacket.INSTANCE.watchPacket(this);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_VALUE, (Object)0);
        if (!this.func_130014_f_().field_72995_K) {
            TickHandlerInfraredPacket.INSTANCE.watchPacket(this);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.func_130014_f_().field_72995_K) {
            TickHandlerInfraredPacket.INSTANCE.unwatchPacket(this);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.lifetime = nbt.func_74762_e(TAG_LIFETIME);
        this.value = nbt.func_74765_d(TAG_VALUE);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a(TAG_LIFETIME, this.lifetime);
        nbt.func_74777_a(TAG_VALUE, this.value);
    }

    public void func_70030_z() {
        if (this.lifetime < 1) {
            this.func_70106_y();
            return;
        }
        super.func_70030_z();
        RayTraceResult hit = this.checkCollisions();
        this.emitParticles(hit);
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult hit) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }

    @Override
    public short getPacketValue() {
        return this.value;
    }

    @Override
    public Vec3d getPacketPosition() {
        return this.func_174791_d();
    }

    @Override
    public Vec3d getPacketDirection() {
        return new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
    }

    @Override
    public void redirectPacket(Vec3d position, Vec3d direction, int addedLifetime) {
        this.lifetime += addedLifetime;
        if (this.lifetime > 0) {
            this.revive();
            Vec3d oldPos = this.func_174791_d();
            Vec3d delta = position.func_178788_d(oldPos);
            double sqrDelta = delta.func_72430_b(delta);
            if (sqrDelta > 576.0) {
                double normalizer = 576.0 / sqrDelta;
                this.field_70165_t = position.field_72450_a * normalizer;
                this.field_70163_u = position.field_72448_b * normalizer;
                this.field_70161_v = position.field_72449_c * normalizer;
            } else {
                this.field_70165_t = position.field_72450_a;
                this.field_70163_u = position.field_72448_b;
                this.field_70161_v = position.field_72449_c;
            }
            Vec3d motionVec = direction.func_72432_b();
            this.field_70159_w = motionVec.field_72450_a * 24.0;
            this.field_70181_x = motionVec.field_72448_b * 24.0;
            this.field_70179_y = motionVec.field_72449_c * 24.0;
        }
    }

    private void emitParticles(@Nullable RayTraceResult hit) {
        double dz;
        double dy;
        double dx;
        World world = this.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        double t = this.field_70146_Z.nextDouble();
        if (hit == null || hit.field_72307_f == null) {
            dx = this.field_70159_w;
            dy = this.field_70181_x;
            dz = this.field_70179_y;
        } else {
            dx = hit.field_72307_f.field_72450_a - this.field_70165_t;
            dy = hit.field_72307_f.field_72448_b - this.field_70163_u;
            dz = hit.field_72307_f.field_72449_c - this.field_70161_v;
        }
        double x = this.field_70165_t + dx * t;
        double y = this.field_70163_u + dy * t;
        double z = this.field_70161_v + dz * t;
        MessageParticleEffect message = new MessageParticleEffect(world, EnumParticleTypes.REDSTONE, x, y, z);
        NetworkRegistry.TargetPoint target = Network.getTargetPoint(world, x, y, z, 16);
        Network.INSTANCE.getWrapper().sendToAllAround((IMessage)message, target);
    }

    private RayTraceResult checkCollisions() {
        RayTraceResult hit = this.checkCollision();
        if (hit != null) {
            Vec3d oldPos = this.func_174791_d();
            switch (hit.field_72313_a) {
                case BLOCK: {
                    this.onBlockCollision(hit);
                    break;
                }
                case ENTITY: {
                    this.onEntityCollision(hit);
                    break;
                }
                default: {
                    return null;
                }
            }
            Vec3d newPos = this.func_174791_d();
            double delta = newPos.func_178788_d(oldPos).func_72433_c() / 24.0;
            this.field_70165_t -= this.field_70159_w * delta;
            this.field_70163_u -= this.field_70181_x * delta;
            this.field_70161_v -= this.field_70179_y * delta;
        }
        return hit;
    }

    private RayTraceResult checkCollision() {
        World world = this.func_130014_f_();
        Vec3d start = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d target = start.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        RayTraceResult blockHit = Raytracing.raytrace(world, start, target, Raytracing::intersectIgnoringTransparent);
        RayTraceResult entityHit = this.checkEntityCollision(world, start, target);
        if (blockHit != null && blockHit.field_72313_a != RayTraceResult.Type.MISS && entityHit != null && entityHit.field_72313_a != RayTraceResult.Type.MISS) {
            if (blockHit.field_72307_f.func_72436_e(start) < entityHit.field_72307_f.func_72436_e(start)) {
                return blockHit;
            }
            return entityHit;
        }
        if (blockHit != null) {
            return blockHit;
        }
        if (entityHit != null) {
            return entityHit;
        }
        return null;
    }

    @Nullable
    private RayTraceResult checkEntityCollision(World world, Vec3d start, Vec3d target) {
        RayTraceResult entityHit = null;
        double bestSqrDistance = Double.POSITIVE_INFINITY;
        List collisions = world.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y));
        for (Entity entity : collisions) {
            double sqrDistance;
            AxisAlignedBB entityBounds;
            RayTraceResult hit;
            if (!entity.func_70067_L() || (hit = (entityBounds = entity.func_174813_aQ()).func_72327_a(start, target)) == null || !((sqrDistance = start.func_72436_e(hit.field_72307_f)) < bestSqrDistance)) continue;
            hit.field_72308_g = entity;
            hit.field_72313_a = RayTraceResult.Type.ENTITY;
            entityHit = hit;
            bestSqrDistance = sqrDistance;
        }
        return entityHit;
    }

    private void onBlockCollision(RayTraceResult hit) {
        InfraredReceiver capability;
        TileEntity tileEntity;
        BlockPos pos;
        World world = this.func_130014_f_();
        if (!world.func_175667_e(pos = hit.func_178782_a())) {
            return;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (hit.field_72313_a == RayTraceResult.Type.BLOCK && block == Blocks.field_150427_aO) {
            this.func_181015_d(pos);
            return;
        }
        this.func_70106_y();
        if (block instanceof InfraredReceiver) {
            ((InfraredReceiver)block).onInfraredPacket(this, hit);
        }
        if ((tileEntity = world.func_175625_s(pos)) != null && (capability = (InfraredReceiver)tileEntity.getCapability(CapabilityInfraredReceiver.INFRARED_RECEIVER_CAPABILITY, hit.field_178784_b)) != null) {
            capability.onInfraredPacket(this, hit);
        }
    }

    private void onEntityCollision(RayTraceResult hit) {
        InfraredReceiver capability;
        this.func_70106_y();
        Entity entity = hit.field_72308_g;
        if (entity != null && (capability = (InfraredReceiver)entity.getCapability(CapabilityInfraredReceiver.INFRARED_RECEIVER_CAPABILITY, hit.field_178784_b)) != null) {
            capability.onInfraredPacket(this, hit);
        }
    }
}

