/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.charsetwires;

import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.charset.api.wires.IBundledEmitter;

public final class CapabilityBundledEmitter {
    public static final ResourceLocation PROVIDER_BUNDLED_EMITTER = new ResourceLocation("tis3d", "charset_bundled_emitter");
    @CapabilityInject(value=IBundledEmitter.class)
    public static Capability<IBundledEmitter> INSTANCE = null;

    public static class Provider
    implements ICapabilityProvider {
        private final BundledEmitter[] emitters = new BundledEmitter[EnumFacing.field_82609_l.length];

        public Provider(TileEntityCasing tileEntity) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.emitters[facing.ordinal()] = new BundledEmitter(tileEntity, facing);
            }
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability != INSTANCE) {
                return false;
            }
            Module module = this.emitters[facing.ordinal()].tileEntity.getModule(Face.fromEnumFacing(facing));
            return module instanceof BundledRedstone;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)this.emitters[facing.ordinal()];
            }
            return null;
        }

        private static final class BundledEmitter
        implements IBundledEmitter {
            private final TileEntityCasing tileEntity;
            private final EnumFacing facing;

            private BundledEmitter(TileEntityCasing tileEntity, EnumFacing facing) {
                this.tileEntity = tileEntity;
                this.facing = facing;
            }

            public byte[] getBundledSignal() {
                Module module = this.tileEntity.getModule(Face.fromEnumFacing(this.facing));
                if (module instanceof BundledRedstone) {
                    BundledRedstone bundledRedstone = (BundledRedstone)module;
                    byte[] signal = new byte[16];
                    for (int channel = 0; channel < signal.length; ++channel) {
                        signal[channel] = (byte)bundledRedstone.getBundledRedstoneOutput(channel);
                    }
                    return signal;
                }
                return null;
            }
        }
    }
}

