/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.charsetwires;

import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.charset.api.wires.IRedstoneEmitter;

public final class CapabilityRedstoneEmitter {
    public static final ResourceLocation PROVIDER_REDSTONE_EMITTER = new ResourceLocation("tis3d", "charset_redstone_emitter");
    @CapabilityInject(value=IRedstoneEmitter.class)
    public static Capability<IRedstoneEmitter> INSTANCE = null;

    public static class Provider
    implements ICapabilityProvider {
        private final RedstoneEmitter[] emitters = new RedstoneEmitter[EnumFacing.field_82609_l.length];

        public Provider(TileEntityCasing tileEntity) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.emitters[facing.ordinal()] = new RedstoneEmitter(tileEntity, facing);
            }
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability != INSTANCE) {
                return false;
            }
            Module module = this.emitters[facing.ordinal()].tileEntity.getModule(Face.fromEnumFacing(facing));
            return module instanceof Redstone;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)this;
            }
            return null;
        }

        private static final class RedstoneEmitter
        implements IRedstoneEmitter {
            private final TileEntityCasing tileEntity;
            private final EnumFacing facing;

            private RedstoneEmitter(TileEntityCasing tileEntity, EnumFacing facing) {
                this.tileEntity = tileEntity;
                this.facing = facing;
            }

            public int getRedstoneSignal() {
                Module module = this.tileEntity.getModule(Face.fromEnumFacing(this.facing));
                if (module instanceof Redstone) {
                    Redstone redstone = (Redstone)module;
                    return redstone.getRedstoneOutput();
                }
                return 0;
            }
        }
    }
}

