/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.minecraft;

import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.serial.SerialProtocolDocumentationReference;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class SerialInterfaceProviderFurnace
implements SerialInterfaceProvider {
    @Override
    public boolean worksWith(World world, BlockPos position, EnumFacing side) {
        return world.func_175625_s(position) instanceof TileEntityFurnace;
    }

    @Override
    public SerialInterface interfaceFor(World world, BlockPos position, EnumFacing side) {
        return new SerialInterfaceFurnace((TileEntityFurnace)world.func_175625_s(position));
    }

    @Override
    public SerialProtocolDocumentationReference getDocumentationReference() {
        return new SerialProtocolDocumentationReference("Minecraft Furnace", "protocols/minecraftFurnace.md");
    }

    @Override
    public boolean isValid(World world, BlockPos position, EnumFacing side, SerialInterface serialInterface) {
        return serialInterface instanceof SerialInterfaceFurnace;
    }

    private static final class SerialInterfaceFurnace
    implements SerialInterface {
        private static final String TAG_MODE = "mode";
        private final TileEntityFurnace furnace;
        private Mode mode = Mode.PercentageFuel;

        public SerialInterfaceFurnace(TileEntityFurnace furnace) {
            this.furnace = furnace;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public void write(short value) {
            this.mode = value == 0 ? Mode.PercentageFuel : Mode.PercentageProgress;
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public short peek() {
            switch (this.mode) {
                case PercentageFuel: {
                    int value = FurnaceField.RemainingFuelTicks.get(this.furnace);
                    int total = FurnaceField.TotalFuelTicks.get(this.furnace);
                    if (total > 0) {
                        return (short)(value * 100 / total);
                    }
                }
                case PercentageProgress: {
                    int value = FurnaceField.AccumulatedSmeltTicks.get(this.furnace);
                    int total = FurnaceField.TotalSmeltTicks.get(this.furnace);
                    if (total <= 0) break;
                    return (short)(value * 100 / total);
                }
            }
            return 0;
        }

        @Override
        public void skip() {
        }

        @Override
        public void reset() {
            this.mode = Mode.PercentageFuel;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.mode = EnumUtils.readFromNBT(Mode.class, TAG_MODE, nbt);
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            EnumUtils.writeToNBT(this.mode, TAG_MODE, nbt);
        }

        private static enum Mode {
            PercentageFuel,
            PercentageProgress;

        }

        private static enum FurnaceField {
            RemainingFuelTicks,
            TotalFuelTicks,
            AccumulatedSmeltTicks,
            TotalSmeltTicks;


            public int get(TileEntityFurnace furnace) {
                return furnace.func_174887_a_(this.ordinal());
            }
        }
    }
}

