/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.redstone;

import java.util.ArrayList;
import java.util.List;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.BundledRedstoneOutputChangedEvent;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.integration.redstone.BundledRedstoneInputProvider;
import li.cil.tis3d.common.integration.redstone.BundledRedstoneOutputChangedCallback;
import li.cil.tis3d.common.integration.redstone.RedstoneInputProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class RedstoneIntegration {
    public static final RedstoneIntegration INSTANCE = new RedstoneIntegration();
    private final List<BundledRedstoneOutputChangedCallback> callbacks = new ArrayList<BundledRedstoneOutputChangedCallback>();
    private final List<RedstoneInputProvider> redstoneInputProviders = new ArrayList<RedstoneInputProvider>();
    private final List<BundledRedstoneInputProvider> bundledRedstoneInputProviders = new ArrayList<BundledRedstoneInputProvider>();

    public void addCallback(BundledRedstoneOutputChangedCallback callback) {
        this.callbacks.add(callback);
    }

    public void addRedstoneInputProvider(RedstoneInputProvider provider) {
        this.redstoneInputProviders.add(provider);
    }

    public void addBundledRedstoneInputProvider(BundledRedstoneInputProvider provider) {
        this.bundledRedstoneInputProviders.add(provider);
    }

    public int getRedstoneInput(Redstone module) {
        int maxSignal = 0;
        for (RedstoneInputProvider provider : this.redstoneInputProviders) {
            try {
                int signal = provider.getInput(module);
                if (signal <= maxSignal) continue;
                maxSignal = signal;
            }
            catch (Throwable t) {
                TIS3D.getLog().warn("Redstone input provider derped!", t);
            }
        }
        return maxSignal;
    }

    public int getBundledRedstoneInput(BundledRedstone module, int channel) {
        int maxSignal = 0;
        for (BundledRedstoneInputProvider provider : this.bundledRedstoneInputProviders) {
            try {
                int signal = provider.getBundledInput(module, channel);
                if (signal <= maxSignal) continue;
                maxSignal = signal;
            }
            catch (Throwable t) {
                TIS3D.getLog().warn("Bundled redstone input provider derped!", t);
            }
        }
        return maxSignal;
    }

    @SubscribeEvent
    public void onBundledRedstoneOutputChanged(BundledRedstoneOutputChangedEvent event) {
        BundledRedstone module = event.getModule();
        int channel = event.getChannel();
        for (BundledRedstoneOutputChangedCallback callback : this.callbacks) {
            callback.onBundledRedstoneOutputChanged(module, channel);
        }
    }

    private RedstoneIntegration() {
    }
}

