/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.inventory;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class Inventory
implements IInventory {
    private static final String TAG_ITEMS = "inventory";
    private final String name;
    private final ItemStack[] items;

    public Inventory(String name, int size) {
        this.name = name;
        this.items = new ItemStack[size];
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList itemList = nbt.func_150295_c(TAG_ITEMS, 10);
        int count = Math.min(itemList.func_74745_c(), this.items.length);
        for (int index = 0; index < count; ++index) {
            this.items[index] = ItemStack.func_77949_a((NBTTagCompound)itemList.func_150305_b(index));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList itemList = new NBTTagList();
        for (ItemStack stack : this.items) {
            NBTTagCompound stackNbt = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(stackNbt);
            }
            itemList.func_74742_a((NBTBase)stackNbt);
        }
        nbt.func_74782_a(TAG_ITEMS, (NBTBase)itemList);
    }

    protected void onItemAdded(int index) {
    }

    protected void onItemRemoved(int index) {
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.items[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.items[index] == null) {
            return null;
        }
        if (this.items[index].field_77994_a <= count) {
            return this.func_70304_b(index);
        }
        ItemStack stack = this.items[index].func_77979_a(count);
        if (this.items[index].field_77994_a < 1) {
            this.items[index] = null;
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.items[index];
        this.func_70299_a(index, null);
        return stack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        if (this.items[index] == stack) {
            return;
        }
        if (this.items[index] != null) {
            this.onItemRemoved(index);
        }
        this.items[index] = stack;
        if (this.items[index] != null) {
            this.onItemAdded(index);
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

