/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.inventory;

import li.cil.tis3d.api.ModuleAPI;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.ModuleProvider;
import li.cil.tis3d.common.inventory.Inventory;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public final class InventoryCasing
extends Inventory
implements ISidedInventory {
    private final TileEntityCasing tileEntity;

    public InventoryCasing(TileEntityCasing tileEntity) {
        super("container.casing", Face.VALUES.length);
        this.tileEntity = tileEntity;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_70296_d() {
        this.tileEntity.func_70296_d();
        if (this.tileEntity.func_145830_o()) {
            IBlockState state = this.tileEntity.func_145831_w().func_180495_p(this.tileEntity.func_174877_v());
            this.tileEntity.func_145831_w().func_184138_a(this.tileEntity.func_174877_v(), state, state, 3);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[side.ordinal()];
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        return side.ordinal() == index && this.func_70301_a(index) == null && this.tileEntity.getModule(Face.fromEnumFacing(side)) == null && this.canInstall(stack, Face.fromEnumFacing(side));
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return side.ordinal() == index && stack == this.func_70301_a(index);
    }

    private boolean canInstall(ItemStack stack, Face face) {
        return ModuleAPI.getProviderFor(stack, this.tileEntity, face) != null;
    }

    @Override
    protected void onItemAdded(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack == null) {
            return;
        }
        Face face = Face.VALUES[index];
        ModuleProvider provider = ModuleAPI.getProviderFor(stack, this.tileEntity, face);
        if (provider == null) {
            return;
        }
        Module module = provider.createModule(stack, this.tileEntity, face);
        if (module != null && !this.tileEntity.getCasingWorld().field_72995_K) {
            module.onInstalled(stack);
        }
        this.tileEntity.setModule(Face.VALUES[index], module);
    }

    @Override
    protected void onItemRemoved(int index) {
        Face face = Face.VALUES[index];
        Module module = this.tileEntity.getModule(face);
        this.tileEntity.setModule(face, null);
        if (module != null && !this.tileEntity.getCasingWorld().field_72995_K) {
            module.onUninstalled(this.func_70301_a(index));
            module.onDisposed();
        }
    }
}

