/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.common.TIS3D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemBookCode
extends ItemBook {
    private static final String TOOLTIP_BOOK_CODE = "tis3d.tooltip.bookCode";

    public ItemBookCode() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        String info = I18n.func_74838_a((String)TOOLTIP_BOOK_CODE);
        tooltip.addAll(this.getFontRenderer(stack).func_78271_c(info, 200));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            player.openGui((Object)TIS3D.instance, 2, world, 0, 0, 0);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return world.func_175625_s(pos) instanceof Casing;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public static class Data {
        public static final Pattern PATTERN_LINES = Pattern.compile("\r?\n");
        private static final String TAG_PAGES = "pages";
        private static final String TAG_SELECTED = "selected";
        private final List<List<String>> programs = new ArrayList<List<String>>();
        private int selectedProgram = 0;

        public int getSelectedProgram() {
            return this.selectedProgram;
        }

        public void setSelectedProgram(int index) {
            this.selectedProgram = index;
            this.validateSelectedPage();
        }

        public int getProgramCount() {
            return this.programs.size();
        }

        public List<String> getProgram(int index) {
            return this.programs.get(index);
        }

        public void addProgram(List<String> code) {
            this.programs.add(code);
        }

        public void setProgram(int page, List<String> code) {
            this.programs.set(page, code);
        }

        public void removeProgram(int index) {
            this.programs.remove(index);
            this.validateSelectedPage();
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.programs.clear();
            NBTTagList pagesNbt = nbt.func_150295_c(TAG_PAGES, 8);
            for (int index = 0; index < pagesNbt.func_74745_c(); ++index) {
                this.programs.add(Arrays.asList(PATTERN_LINES.split(pagesNbt.func_150307_f(index))));
            }
            this.selectedProgram = nbt.func_74762_e(TAG_SELECTED);
            this.validateSelectedPage();
        }

        public void writeToNBT(NBTTagCompound nbt) {
            NBTTagList pagesNbt = new NBTTagList();
            int removed = 0;
            for (int index = 0; index < this.programs.size(); ++index) {
                List<String> program = this.programs.get(index);
                if (program.size() > 1 || program.get(0).length() > 0) {
                    pagesNbt.func_74742_a((NBTBase)new NBTTagString(String.join((CharSequence)"\n", program)));
                    continue;
                }
                if (index >= this.selectedProgram) continue;
                ++removed;
            }
            nbt.func_74782_a(TAG_PAGES, (NBTBase)pagesNbt);
            nbt.func_74768_a(TAG_SELECTED, this.selectedProgram - removed);
        }

        private void validateSelectedPage() {
            this.selectedProgram = Math.max(0, Math.min(this.programs.size() - 1, this.selectedProgram));
        }

        public static Data loadFromNBT(NBTTagCompound nbt) {
            Data data = new Data();
            if (nbt != null) {
                data.readFromNBT(nbt);
            }
            return data;
        }

        public static Data loadFromStack(ItemStack stack) {
            return Data.loadFromNBT(stack.func_77978_p());
        }

        public static void saveToStack(ItemStack stack, Data data) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            data.writeToNBT(stack.func_77978_p());
        }
    }
}

