/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.machine;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.tis3d.api.ModuleAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.ModuleProvider;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class CasingImpl
implements Casing {
    private final Module[] modules = new Module[Face.VALUES.length];
    private Optional<UUID> lock = Optional.empty();
    private static final String TAG_MODULES = "modules";
    private static final String TAG_KEY_MS = "keyMostSignificant";
    private static final String TAG_KEY_LS = "keyLeastSignificant";
    private final TileEntityCasing tileEntity;

    public CasingImpl(TileEntityCasing tileEntity) {
        this.tileEntity = tileEntity;
    }

    public void onEnabled() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.onEnabled();
        }
        this.markDirty();
    }

    public void onDisabled() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.onDisabled();
        }
        for (Pipe pipe : this.tileEntity.getPipes()) {
            pipe.cancelRead();
            pipe.cancelWrite();
        }
        this.markDirty();
    }

    public void onDisposed() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.onDisposed();
        }
    }

    public void stepModules() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.step();
        }
    }

    public void lock(ItemStack stack) {
        if (this.isLocked()) {
            throw new IllegalStateException("Casing is already locked.");
        }
        if (Items.isKeyCreative(stack)) {
            this.lock = Optional.of(UUID.randomUUID());
        } else {
            UUID key = CasingImpl.getKeyFromStack(stack).orElse(UUID.randomUUID());
            CasingImpl.setKeyForStack(stack, key);
            this.lock = Optional.of(key);
        }
        IBlockState state = this.getCasingWorld().func_180495_p(this.getPosition());
        this.getCasingWorld().func_184138_a(this.getPosition(), state, state, 3);
    }

    public void unlock(ItemStack stack) {
        if (Items.isKeyCreative(stack)) {
            this.lock = Optional.empty();
            IBlockState state = this.getCasingWorld().func_180495_p(this.getPosition());
            this.getCasingWorld().func_184138_a(this.getPosition(), state, state, 3);
        } else {
            CasingImpl.getKeyFromStack(stack).ifPresent(this::unlock);
        }
    }

    public void unlock(UUID key) {
        if (this.lock.map(key::equals).orElse(false).booleanValue()) {
            this.lock = Optional.empty();
            IBlockState state = this.getCasingWorld().func_180495_p(this.getPosition());
            this.getCasingWorld().func_184138_a(this.getPosition(), state, state, 3);
        }
    }

    public void setModule(Face face, @Nullable Module module) {
        if (this.getModule(face) == module) {
            return;
        }
        Module oldModule = this.getModule(face);
        if (this.tileEntity.isEnabled() && oldModule != null && this.getCasingWorld() != null && !this.getCasingWorld().field_72995_K) {
            oldModule.onDisabled();
        }
        boolean hadRedstone = oldModule instanceof Redstone;
        this.modules[face.ordinal()] = module;
        if (hadRedstone && !this.getCasingWorld().field_72995_K) {
            this.tileEntity.func_70296_d();
            this.getCasingWorld().func_175685_c(this.getPosition(), this.tileEntity.func_145838_q());
        }
        if (module == null) {
            for (Port port : Port.VALUES) {
                this.getReceivingPipe(face, port).cancelRead();
                this.getSendingPipe(face, port).cancelWrite();
            }
        }
        if (this.tileEntity.isEnabled() && module != null && this.getCasingWorld() != null && !this.getCasingWorld().field_72995_K) {
            module.onEnabled();
        }
        this.tileEntity.func_70296_d();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        for (int index = 0; index < this.tileEntity.func_70302_i_(); ++index) {
            Module module;
            ItemStack stack = this.tileEntity.func_70301_a(index);
            if (stack == null) {
                if (this.modules[index] != null) {
                    this.modules[index].onDisposed();
                }
                this.modules[index] = null;
                continue;
            }
            Face face = Face.VALUES[index];
            ModuleProvider provider = ModuleAPI.getProviderFor(stack, this.tileEntity, face);
            if (provider == null) {
                if (this.modules[index] != null) {
                    this.modules[index].onDisposed();
                }
                this.modules[index] = null;
                continue;
            }
            this.modules[index] = module = provider.createModule(stack, this.tileEntity, face);
        }
        NBTTagList modulesNbt = nbt.func_150295_c(TAG_MODULES, 10);
        int moduleCount = Math.min(modulesNbt.func_74745_c(), this.modules.length);
        for (int i = 0; i < moduleCount; ++i) {
            if (this.modules[i] == null) continue;
            this.modules[i].readFromNBT(modulesNbt.func_150305_b(i));
        }
        this.lock = nbt.func_74764_b(TAG_KEY_MS) && nbt.func_74764_b(TAG_KEY_LS) ? Optional.of(new UUID(nbt.func_74763_f(TAG_KEY_MS), nbt.func_74763_f(TAG_KEY_LS))) : Optional.empty();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList modulesNbt = new NBTTagList();
        for (Module module : this.modules) {
            NBTTagCompound moduleNbt = new NBTTagCompound();
            if (module != null) {
                module.writeToNBT(moduleNbt);
            }
            modulesNbt.func_74742_a((NBTBase)moduleNbt);
        }
        nbt.func_74782_a(TAG_MODULES, (NBTBase)modulesNbt);
        this.lock.ifPresent(key -> nbt.func_74772_a(TAG_KEY_MS, key.getMostSignificantBits()));
        this.lock.ifPresent(key -> nbt.func_74772_a(TAG_KEY_LS, key.getLeastSignificantBits()));
    }

    private static Optional<UUID> getKeyFromStack(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return Optional.empty();
        }
        if (!nbt.func_74764_b(TAG_KEY_MS) || !nbt.func_74764_b(TAG_KEY_LS)) {
            return Optional.empty();
        }
        return Optional.of(new UUID(nbt.func_74763_f(TAG_KEY_MS), nbt.func_74763_f(TAG_KEY_LS)));
    }

    private static void setKeyForStack(ItemStack stack, UUID key) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74772_a(TAG_KEY_MS, key.getMostSignificantBits());
        nbt.func_74772_a(TAG_KEY_LS, key.getLeastSignificantBits());
    }

    @Override
    @Nullable
    public World getCasingWorld() {
        return this.tileEntity.func_145831_w();
    }

    @Override
    public BlockPos getPosition() {
        return this.tileEntity.func_174877_v();
    }

    @Override
    public void markDirty() {
        this.tileEntity.func_70296_d();
    }

    @Override
    public boolean isLocked() {
        return this.lock.isPresent();
    }

    @Override
    @Nullable
    public Module getModule(Face face) {
        return this.modules[face.ordinal()];
    }

    @Override
    public Pipe getReceivingPipe(Face face, Port port) {
        return this.tileEntity.getReceivingPipe(face, port);
    }

    @Override
    public Pipe getSendingPipe(Face face, Port port) {
        return this.tileEntity.getSendingPipe(face, port);
    }

    @Override
    public void sendData(Face face, NBTTagCompound data, byte type) {
        Network.sendModuleData((Casing)this, face, data, type);
    }

    @Override
    public void sendData(Face face, NBTTagCompound data) {
        this.sendData(face, data, (byte)-1);
    }

    @Override
    public void sendData(Face face, ByteBuf data, byte type) {
        Network.sendModuleData((Casing)this, face, data, type);
    }

    @Override
    public void sendData(Face face, ByteBuf data) {
        this.sendData(face, data, (byte)-1);
    }
}

