/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.machine;

import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.machine.PipeHost;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public final class PipeImpl
implements Pipe {
    private State readState = State.IDLE;
    private State writeState = State.IDLE;
    private short value = 0;
    private static final String TAG_READ_STATE = "readState";
    private static final String TAG_WRITE_STATE = "writeState";
    private static final String TAG_VALUE = "value";
    private final PipeHost host;
    private final Face receivingFace;
    private final Face sendingFace;
    private final Port sendingPort;

    public PipeImpl(PipeHost host, Face receivingFace, Face sendingFace, Port sendingPort) {
        this.host = host;
        this.receivingFace = receivingFace;
        this.sendingFace = sendingFace;
        this.sendingPort = sendingPort;
    }

    public void step() {
        if (this.writeState == State.BUSY) {
            this.writeState = State.READY;
        } else if (this.readState == State.BUSY) {
            this.readState = State.READY;
        } else if (this.writeState == State.READY && this.readState == State.READY) {
            this.writeState = State.FLUSHING;
            this.readState = State.FLUSHING;
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.readState = EnumUtils.readFromNBT(State.class, TAG_READ_STATE, nbt);
        this.writeState = EnumUtils.readFromNBT(State.class, TAG_WRITE_STATE, nbt);
        this.value = nbt.func_74765_d(TAG_VALUE);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        EnumUtils.writeToNBT(this.readState, TAG_READ_STATE, nbt);
        EnumUtils.writeToNBT(this.writeState, TAG_WRITE_STATE, nbt);
        nbt.func_74777_a(TAG_VALUE, this.value);
    }

    @Override
    public void beginWrite(short value) {
        if (this.writeState != State.IDLE) {
            throw new IllegalStateException("Trying to write to a busy pipe. Check isWriting().");
        }
        this.writeState = State.BUSY;
        this.value = value;
    }

    @Override
    public void cancelWrite() {
        this.writeState = State.IDLE;
        this.value = 0;
        if (this.readState == State.FLUSHING) {
            this.readState = State.READY;
        }
    }

    @Override
    public boolean isWriting() {
        return this.writeState != State.IDLE;
    }

    @Override
    public void beginRead() {
        if (this.readState != State.IDLE) {
            throw new IllegalStateException("Trying to write to a busy pipe. Check isReading().");
        }
        this.readState = State.BUSY;
    }

    @Override
    public void cancelRead() {
        this.readState = State.IDLE;
        if (this.writeState == State.FLUSHING) {
            this.writeState = State.READY;
        }
    }

    @Override
    public boolean isReading() {
        return this.readState != State.IDLE;
    }

    @Override
    public boolean canTransfer() {
        return this.writeState == State.FLUSHING && this.readState == State.FLUSHING;
    }

    @Override
    public short read() {
        if (!this.canTransfer()) {
            throw new IllegalStateException("No data to read. Check canTransfer().");
        }
        BlockPos position = this.host.getPipeHostPosition();
        double ox = Face.toEnumFacing(this.receivingFace).func_82601_c() + Face.toEnumFacing(this.sendingFace).func_82601_c();
        double oy = Face.toEnumFacing(this.receivingFace).func_96559_d() + Face.toEnumFacing(this.sendingFace).func_96559_d();
        double oz = Face.toEnumFacing(this.receivingFace).func_82599_e() + Face.toEnumFacing(this.sendingFace).func_82599_e();
        double x = ox * 0.55 + (double)position.func_177958_n() + 0.5;
        double y = oy * 0.55 + (double)position.func_177956_o() + 0.5;
        double z = oz * 0.55 + (double)position.func_177952_p() + 0.5;
        double extraOffsetY = oy < 0.0 ? -0.2 : (oy > 0.0 ? 0.1 : 0.0);
        Network.sendPipeEffect(this.host.getPipeHostWorld(), x, y + extraOffsetY, z);
        short result = this.value;
        this.cancelWrite();
        this.cancelRead();
        this.host.onWriteComplete(this.sendingFace, this.sendingPort);
        return result;
    }

    public String toString() {
        return this.host.getPipeHostPosition() + ": " + (Object)((Object)this.sendingFace) + " [" + (Object)((Object)this.writeState) + "] -> " + (Object)((Object)this.receivingFace) + " [" + (Object)((Object)this.readState) + "]";
    }

    private static enum State {
        IDLE,
        BUSY,
        READY,
        FLUSHING;

    }
}

