/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.render.TextureLoader;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageParticleEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleAudio
extends AbstractModule {
    private static final SoundEvent[] INSTRUMENTS = new SoundEvent[]{SoundEvents.field_187682_dG, SoundEvents.field_187676_dE, SoundEvents.field_187688_dI, SoundEvents.field_187685_dH, SoundEvents.field_187679_dF};
    private long lastStep = 0L;

    public ModuleAudio(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.stepInput();
        this.lastStep = world.func_82737_E();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(TextureLoader.LOCATION_MODULE_AUDIO_OVERLAY.toString());
        RenderUtil.drawQuad(icon.func_94209_e(), icon.func_94206_g(), icon.func_94212_f(), icon.func_94210_h());
        GlStateManager.func_179084_k();
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            World world = this.getCasing().getCasingWorld();
            assert (world != null);
            if (world.func_82737_E() <= this.lastStep) continue;
            this.playNote(receivingPipe.read());
            receivingPipe.beginRead();
        }
    }

    private void playNote(int value) {
        int noteId = (value & 0xFF00) >>> 8;
        int volume = Math.min(4, (value & 0xF0) >>> 4);
        int instrumentId = value & 0xF;
        if (volume < 1) {
            return;
        }
        World world = this.getCasing().getCasingWorld();
        assert (world != null);
        BlockPos pos = this.getCasing().getPosition();
        NoteBlockEvent.Play event = new NoteBlockEvent.Play(world, pos, world.func_180495_p(pos), noteId, instrumentId);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            int note = event.getVanillaNoteId();
            float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
            SoundEvent sound = INSTRUMENTS[event.getInstrument().ordinal()];
            EnumFacing facing = Face.toEnumFacing(this.getFace());
            double x = (double)pos.func_177958_n() + 0.5 + (double)facing.func_82601_c() * 0.6;
            double y = (double)pos.func_177956_o() + 0.5 + (double)facing.func_96559_d() * 0.6;
            double z = (double)pos.func_177952_p() + 0.5 + (double)facing.func_82599_e() * 0.6;
            world.func_184148_a(null, x, y, z, sound, SoundCategory.BLOCKS, (float)volume, pitch);
            MessageParticleEffect message = new MessageParticleEffect(world, EnumParticleTypes.NOTE, x, y, z);
            NetworkRegistry.TargetPoint target = Network.getTargetPoint(world, x, y, z, 16);
            Network.INSTANCE.getWrapper().sendToAllAround((IMessage)message, target);
        }
    }
}

