/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.Deque;
import java.util.LinkedList;
import li.cil.tis3d.api.InfraredAPI;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.render.TextureLoader;
import li.cil.tis3d.common.Settings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleInfrared
extends AbstractModule
implements InfraredReceiver {
    private final Deque<Short> receiveQueue = new LinkedList<Short>();
    private static final String TAG_RECEIVE_QUEUE = "receiveQueue";
    private long lastStep = 0L;

    public ModuleInfrared(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.stepOutput();
        this.stepInput();
        this.lastStep = this.getCasing().getCasingWorld().func_82737_E();
    }

    @Override
    public void onDisabled() {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.receiveQueue.clear();
    }

    @Override
    public void onWriteComplete(Port port) {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.receiveQueue.removeFirst();
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        GlStateManager.func_179147_l();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(TextureLoader.LOCATION_MODULE_INFRARED_OVERLAY.toString());
        RenderUtil.drawQuad(icon.func_94209_e(), icon.func_94206_g(), icon.func_94212_f(), icon.func_94210_h());
        GlStateManager.func_179084_k();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int[] receiveQueueNbt;
        super.readFromNBT(nbt);
        this.receiveQueue.clear();
        for (int value : receiveQueueNbt = nbt.func_74759_k(TAG_RECEIVE_QUEUE)) {
            this.receiveQueue.addLast((short)value);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        int[] receiveQueueArray = new int[this.receiveQueue.size()];
        int i = 0;
        for (short value : this.receiveQueue) {
            receiveQueueArray[i++] = value;
        }
        NBTTagIntArray receiveQueueNbt = new NBTTagIntArray(receiveQueueArray);
        nbt.func_74782_a(TAG_RECEIVE_QUEUE, (NBTBase)receiveQueueNbt);
    }

    @Override
    public void onInfraredPacket(InfraredPacket packet, RayTraceResult hit) {
        World world = this.getCasing().getCasingWorld();
        assert (world != null);
        if (world.field_72995_K) {
            return;
        }
        short value = packet.getPacketValue();
        if (this.receiveQueue.size() < Settings.maxInfraredQueueLength) {
            this.receiveQueue.addLast(value);
        }
    }

    private void stepOutput() {
        if (this.receiveQueue.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.receiveQueue.peekFirst());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            World world = this.getCasing().getCasingWorld();
            assert (world != null);
            if (world.func_82737_E() <= this.lastStep) continue;
            this.emitInfraredPacket(receivingPipe.read());
            receivingPipe.beginRead();
        }
    }

    private void emitInfraredPacket(short value) {
        EnumFacing facing = Face.toEnumFacing(this.getFace());
        BlockPos blockPos = this.getCasing().getPosition().func_177972_a(facing);
        World world = this.getCasing().getCasingWorld();
        Vec3d position = new Vec3d((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
        Vec3d direction = new Vec3d((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e());
        InfraredAPI.sendPacket(world, position, direction, value);
    }
}

