/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.Optional;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleKeypad
extends AbstractModuleRotatable {
    private Optional<Short> value = Optional.empty();
    public static final String TAG_VALUE = "value";
    private static final byte DATA_TYPE_VALUE = 0;
    private static final ResourceLocation LOCATION_OVERLAY = new ResourceLocation("tis3d", "textures/blocks/overlay/moduleKeypad.png");
    public static final float KEYS_U0 = 0.15625f;
    public static final float KEYS_V0 = 0.15625f;
    public static final float KEYS_SIZE_U = 0.15625f;
    public static final float KEYS_SIZE_V = 0.15625f;
    public static final float KEYS_SIZE_V_LAST = 0.125f;
    public static final float KEYS_STEP_U = 0.1875f;
    public static final float KEYS_STEP_V = 0.1875f;

    public ModuleKeypad(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.value = Optional.empty();
        this.cancelWrite();
        this.getCasing().sendData(this.getFace(), new NBTTagCompound(), (byte)0);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (this.value.isPresent()) {
            return true;
        }
        World world = this.getCasing().getCasingWorld();
        assert (world != null);
        if (world.field_72995_K) {
            Vec3d uv = this.hitToUV(new Vec3d((double)hitX, (double)hitY, (double)hitZ));
            int button = this.uvToButton((float)uv.field_72450_a, (float)uv.field_72448_b);
            if (button == -1) {
                return true;
            }
            short number = this.buttonToNumber(button);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74777_a(TAG_VALUE, number);
            this.getCasing().sendData(this.getFace(), nbt, (byte)0);
        }
        return true;
    }

    @Override
    public void onData(NBTTagCompound nbt) {
        World world = this.getCasing().getCasingWorld();
        assert (world != null);
        if (world.field_72995_K) {
            this.value = nbt.func_74764_b(TAG_VALUE) ? Optional.of(nbt.func_74765_d(TAG_VALUE)) : Optional.empty();
        } else if (!this.value.isPresent() && nbt.func_74764_b(TAG_VALUE)) {
            this.value = Optional.of(nbt.func_74765_d(TAG_VALUE));
            this.getCasing().sendData(this.getFace(), nbt, (byte)0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        Vec3d hitPos;
        if (!enabled || !this.isVisible()) {
            return;
        }
        this.rotateForRendering();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        RenderUtil.bindTexture(LOCATION_OVERLAY);
        if (this.value.isPresent()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        GlStateManager.func_179132_a((boolean)false);
        RenderUtil.drawQuad();
        GlStateManager.func_179132_a((boolean)true);
        if (!this.value.isPresent() && (hitPos = this.getPlayerLookAt()) != null) {
            Vec3d uv = this.hitToUV(hitPos);
            int button = this.uvToButton((float)uv.field_72450_a, (float)uv.field_72448_b);
            if (button >= 0) {
                this.drawButtonOverlay(button);
            }
        }
        GlStateManager.func_179084_k();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b(TAG_VALUE)) {
            this.value = Optional.of(nbt.func_74765_d(TAG_VALUE));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.value.ifPresent(x -> nbt.func_74777_a(TAG_VALUE, x.shortValue()));
    }

    private void stepOutput() {
        if (!this.value.isPresent()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.value.get());
        }
    }

    private int uvToButton(float u, float v) {
        int button;
        float u0;
        if (u < 0.15625f || u > 0.6875f) {
            return -1;
        }
        if (v < 0.15625f || v > 0.875f) {
            return -1;
        }
        int row = 0;
        float v0 = v - 0.15625f;
        while (true) {
            float f = row == 3 ? 0.125f : 0.15625f;
            if (!(v0 > f)) break;
            ++row;
            v0 -= 0.1875f;
        }
        if (v0 < 0.0f) {
            return -1;
        }
        int column = row == 3 ? -1 : 0;
        for (u0 = u - 0.15625f; u0 > 0.15625f; u0 -= 0.1875f) {
            ++column;
        }
        if (u0 < 0.0f && row != 3 && column != 1) {
            return -1;
        }
        if (column < 0) {
            column = 0;
        }
        if ((button = row * 3 + column) > 9) {
            return -1;
        }
        return button;
    }

    private short buttonToNumber(int button) {
        return (short)((button + 1) % 10);
    }

    private void drawButtonOverlay(int button) {
        int column = button % 3;
        int row = button / 3;
        float x = 0.15625f + (float)column * 0.1875f;
        float y = 0.15625f + (float)row * 0.1875f;
        float w = this.buttonToNumber(button) == 0 ? 0.34375f : 0.15625f;
        float h = row == 3 ? 0.125f : 0.15625f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        RenderUtil.drawUntexturedQuad(x, y, w, h);
        GlStateManager.func_179098_w();
    }
}

