/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleRandomAccessMemory
extends AbstractModuleRotatable {
    private byte[] memory = new byte[256];
    private byte address;
    private State state = State.ADDRESS;
    private static final int MEMORY_SIZE = 256;
    private static final String TAG_MEMORY = "memory";
    private static final String TAG_ADDRESS = "address";
    private static final String TAG_STATE = "state";
    private static final byte DATA_TYPE_CLEAR = 0;
    public static final float QUADS_U0 = 0.15625f;
    public static final float QUADS_V0 = 0.15625f;
    public static final float QUADS_SIZE_U = 0.125f;
    public static final float QUADS_SIZE_V = 0.125f;
    public static final float QUADS_STEP_U = 0.1875f;
    public static final float QUADS_STEP_V = 0.1875f;

    public ModuleRandomAccessMemory(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        Arrays.fill(this.memory, (byte)0);
        this.address = 0;
        this.state = State.ADDRESS;
        this.sendClear();
    }

    @Override
    public void onWriteComplete(Port port) {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.state = State.ADDRESS;
        this.cancelWrite();
    }

    @Override
    public void onData(ByteBuf data) {
        if (data.readBoolean()) {
            Arrays.fill(this.memory, (byte)0);
        } else {
            this.address = data.readByte();
            this.set(data.readByte());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled || !this.isVisible()) {
            return;
        }
        this.rotateForRendering();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        GlStateManager.func_179090_x();
        int step = 4;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int offset = (y * 4 + x) * 4;
                float brightness = 0.25f + this.sectorSum(offset) * 0.75f;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
                float u0 = 0.15625f + (float)x * 0.1875f;
                float v0 = 0.15625f + (float)y * 0.1875f;
                RenderUtil.drawUntexturedQuad(u0, v0, 0.125f, 0.125f);
            }
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.memory = nbt.func_74770_j(TAG_MEMORY);
        this.address = nbt.func_74771_c(TAG_ADDRESS);
        this.state = EnumUtils.readFromNBT(State.class, TAG_STATE, nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74773_a(TAG_MEMORY, this.memory);
        nbt.func_74774_a(TAG_ADDRESS, this.address);
        EnumUtils.writeToNBT(this.state, TAG_STATE, nbt);
    }

    private int get() {
        return this.memory[this.address & 0xFF] & 0xFF;
    }

    private void set(int value) {
        this.memory[this.address & 0xFF] = (byte)value;
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.process(receivingPipe.read());
            receivingPipe.beginRead();
        }
    }

    private void process(short value) {
        switch (this.state) {
            case ADDRESS: {
                this.beginReadWrite((byte)value);
                break;
            }
            case READ_WRITE: {
                this.finishReading((byte)value);
            }
        }
    }

    private void beginReadWrite(byte address) {
        this.address = address;
        this.state = State.READ_WRITE;
        short value = (short)this.get();
        for (Port port : Port.VALUES) {
            this.getCasing().getSendingPipe(this.getFace(), port).beginWrite(value);
        }
    }

    private void finishReading(byte value) {
        this.set(value);
        this.state = State.ADDRESS;
        this.cancelWrite();
        this.sendData();
    }

    private void sendClear() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(true);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(false);
        data.writeByte((int)this.address);
        data.writeByte((int)this.memory[this.address & 0xFF]);
        this.getCasing().sendData(this.getFace(), data);
    }

    private float sectorSum(int offset) {
        int sum = (this.memory[offset] & 0xFF) + (this.memory[offset + 1] & 0xFF) + (this.memory[offset + 2] & 0xFF) + (this.memory[offset + 3] & 0xFF);
        return (float)sum / 1020.0f;
    }

    private static enum State {
        ADDRESS,
        READ_WRITE;

    }
}

