/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.Optional;
import li.cil.tis3d.api.SerialAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.BlockChangeAware;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.util.RenderUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleSerialPort
extends AbstractModule
implements BlockChangeAware {
    private short writing;
    private static final String TAG_VALUE = "value";
    private static final String TAG_SERIAL_INTERFACE = "serialInterface";
    private static final ResourceLocation LOCATION_OVERLAY = new ResourceLocation("tis3d", "textures/blocks/overlay/moduleSerialPort.png");
    private Optional<SerialInterface> serialInterface = Optional.empty();
    private Optional<NBTTagCompound> serialInterfaceNbt = Optional.empty();
    private boolean isScanScheduled = true;

    public ModuleSerialPort(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void onNeighborBlockChange(Block neighborBlock) {
        this.isScanScheduled = true;
    }

    @Override
    public void step() {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.scan();
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.serialInterface.ifPresent(SerialInterface::reset);
    }

    @Override
    public void onWriteComplete(Port port) {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.serialInterface.ifPresent(SerialInterface::skip);
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        RenderUtil.bindTexture(LOCATION_OVERLAY);
        RenderUtil.drawQuad();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.writing = nbt.func_74765_d(TAG_VALUE);
        if (nbt.func_74764_b(TAG_SERIAL_INTERFACE)) {
            if (this.serialInterface.isPresent()) {
                this.serialInterface.get().readFromNBT(nbt.func_74775_l(TAG_SERIAL_INTERFACE));
            } else {
                this.serialInterfaceNbt = Optional.of(nbt.func_74775_l(TAG_SERIAL_INTERFACE));
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74777_a(TAG_VALUE, this.writing);
        if (this.serialInterface.isPresent()) {
            NBTTagCompound serialInterfaceNbt = new NBTTagCompound();
            this.serialInterface.get().writeToNBT(serialInterfaceNbt);
            if (!nbt.func_82582_d()) {
                nbt.func_74782_a(TAG_SERIAL_INTERFACE, (NBTBase)serialInterfaceNbt);
            }
        }
    }

    private void scan() {
        if (!this.isScanScheduled) {
            return;
        }
        this.isScanScheduled = false;
        World world = this.getCasing().getCasingWorld();
        assert (world != null);
        BlockPos neighborPos = this.getCasing().getPosition().func_177972_a(Face.toEnumFacing(this.getFace()));
        EnumFacing neighborSide = Face.toEnumFacing(this.getFace().getOpposite());
        if (world.func_175667_e(neighborPos)) {
            SerialInterfaceProvider provider = SerialAPI.getProviderFor(world, neighborPos, neighborSide);
            if (provider != null) {
                if (!this.serialInterface.map(s -> provider.isValid(world, neighborPos, neighborSide, (SerialInterface)s)).orElse(false).booleanValue()) {
                    this.reset();
                    this.serialInterface = Optional.ofNullable(provider.interfaceFor(world, neighborPos, neighborSide));
                    if (this.serialInterface.isPresent() && this.serialInterfaceNbt.isPresent()) {
                        this.serialInterface.get().readFromNBT(this.serialInterfaceNbt.get());
                        this.serialInterfaceNbt = Optional.empty();
                    }
                }
            } else {
                this.reset();
            }
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.serialInterface.ifPresent(SerialInterface::reset);
        this.serialInterface = Optional.empty();
        this.cancelRead();
        this.cancelWrite();
    }

    private void stepOutput() {
        if (this.serialInterface.map(SerialInterface::canRead).orElse(false).booleanValue()) {
            short value = this.serialInterface.map(SerialInterface::peek).orElse((short)0);
            if (value != this.writing) {
                this.cancelWrite();
                this.writing = value;
            }
            for (Port port : Port.VALUES) {
                Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
                if (sendingPipe.isWriting()) continue;
                sendingPipe.beginWrite(this.writing);
            }
        } else {
            this.cancelWrite();
        }
    }

    private void stepInput() {
        if (this.serialInterface.map(SerialInterface::canWrite).orElse(false).booleanValue()) {
            for (Port port : Port.VALUES) {
                Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
                if (!receivingPipe.isReading()) {
                    receivingPipe.beginRead();
                }
                if (!receivingPipe.canTransfer()) continue;
                this.serialInterface.ifPresent(s -> s.write(receivingPipe.read()));
                if (!this.serialInterface.map(SerialInterface::canWrite).orElse(false).booleanValue()) continue;
                receivingPipe.beginRead();
            }
        } else {
            this.cancelRead();
        }
    }
}

