/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.FontRendererAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleStack
extends AbstractModuleRotatable {
    private final short[] stack = new short[16];
    private int top = -1;
    private static final String TAG_STACK = "stack";
    private static final String TAG_TOP = "top";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final int STACK_SIZE = 16;
    private static final ResourceLocation LOCATION_OVERLAY = new ResourceLocation("tis3d", "textures/blocks/overlay/moduleStack.png");

    public ModuleStack(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.top = -1;
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        World world = this.getCasing().getCasingWorld();
        assert (world != null && !world.field_72995_K);
        this.pop();
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    public void onData(ByteBuf data) {
        this.top = data.readByte();
        for (int i = 0; i < this.stack.length; ++i) {
            this.stack[i] = data.readShort();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        this.rotateForRendering();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        RenderUtil.bindTexture(LOCATION_OVERLAY);
        RenderUtil.drawQuad();
        if (!this.isEmpty() && Minecraft.func_71410_x().field_71439_g.func_174831_c(this.getCasing().getPosition()) < 64.0) {
            this.drawState();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        int[] stackNbt = nbt.func_74759_k(TAG_STACK);
        int count = Math.min(stackNbt.length, this.stack.length);
        for (int i = 0; i < count; ++i) {
            this.stack[i] = (short)stackNbt[i];
        }
        this.top = Math.max(-1, Math.min(15, nbt.func_74762_e(TAG_TOP)));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        int[] stackNbt = new int[this.stack.length];
        for (int i = 0; i < this.stack.length; ++i) {
            stackNbt[i] = this.stack[i];
        }
        nbt.func_74783_a(TAG_STACK, stackNbt);
        nbt.func_74768_a(TAG_TOP, this.top);
    }

    private boolean isEmpty() {
        return this.top < 0;
    }

    private boolean isFull() {
        return this.top >= 15;
    }

    private void push(short value) {
        this.stack[++this.top] = value;
        this.sendData();
    }

    private short peek() {
        return this.stack[this.top];
    }

    private void pop() {
        this.top = Math.max(-1, this.top - 1);
        this.sendData();
    }

    private void stepOutput() {
        if (this.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.peek());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            if (this.isFull()) {
                return;
            }
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.push(receivingPipe.read());
            this.cancelWrite();
            if (this.isFull()) continue;
            receivingPipe.beginRead();
        }
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(this.top);
        for (short value : this.stack) {
            data.writeShort((int)value);
        }
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @SideOnly(value=Side.CLIENT)
    private void drawState() {
        GlStateManager.func_179109_b((float)0.1875f, (float)0.3125f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)1.0f);
        GlStateManager.func_179109_b((float)4.5f, (float)14.5f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i <= this.top; ++i) {
            FontRendererAPI.drawString(String.format("%4X", this.stack[i]));
            GlStateManager.func_179109_b((float)0.0f, (float)(FontRendererAPI.getCharHeight() + 1), (float)0.0f);
            if ((i + 1) % 4 != 0) continue;
            GlStateManager.func_179109_b((float)((FontRendererAPI.getCharWidth() + 1) * 5), (float)((FontRendererAPI.getCharHeight() + 1) * -4), (float)0.0f);
        }
    }
}

