/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.item.ItemBookCode;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.nbt.NBTTagCompound;

public final class MachineState {
    public int pc = 0;
    public short acc = 0;
    public short bak = 0;
    public Optional<Port> last = Optional.empty();
    public String[] code;
    public static final String TAG_CODE = "code";
    public static final String TAG_PC = "pc";
    public static final String TAG_ACC = "acc";
    public static final String TAG_BAK = "bak";
    public static final String TAG_LAST = "last";
    public final List<Instruction> instructions = new ArrayList<Instruction>(Settings.maxLinesPerProgram);
    public final HashMap<String, Integer> labels = new HashMap(Settings.maxLinesPerProgram);
    public final HashMap<Integer, Integer> lineNumbers = new HashMap(Settings.maxLinesPerProgram);

    public void validate() {
        if (this.pc < 0 || this.pc >= this.instructions.size()) {
            this.pc = 0;
        }
    }

    public void reset() {
        this.pc = 0;
        this.acc = 0;
        this.bak = 0;
        this.last = Optional.empty();
        this.instructions.forEach(Instruction::reset);
    }

    public void clear() {
        this.reset();
        this.instructions.clear();
        this.labels.clear();
        this.code = null;
        this.lineNumbers.clear();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(TAG_CODE)) {
            try {
                Compiler.compile(Arrays.asList(ItemBookCode.Data.PATTERN_LINES.split(nbt.func_74779_i(TAG_CODE))), this);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.pc = nbt.func_74762_e(TAG_PC);
        this.acc = nbt.func_74765_d(TAG_ACC);
        this.bak = nbt.func_74765_d(TAG_BAK);
        this.last = nbt.func_74764_b(TAG_LAST) ? Optional.of(EnumUtils.readFromNBT(Port.class, TAG_LAST, nbt)) : Optional.empty();
        this.validate();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(TAG_PC, this.pc);
        nbt.func_74777_a(TAG_ACC, this.acc);
        nbt.func_74777_a(TAG_BAK, this.bak);
        this.last.ifPresent(port -> EnumUtils.writeToNBT(port, TAG_LAST, nbt));
        if (this.code != null) {
            nbt.func_74778_a(TAG_CODE, String.join((CharSequence)"\n", this.code));
        }
    }
}

