/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.compiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.compiler.Validator;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitter;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterLabel;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterMissing;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterMove;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterTargetOrImmediate;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitterUnary;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.common.module.execution.instruction.InstructionAdd;
import li.cil.tis3d.common.module.execution.instruction.InstructionAddImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseAnd;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseAndImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseNot;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseOr;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseOrImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseShiftLeft;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseShiftLeftImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseShiftRight;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseShiftRightImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseXor;
import li.cil.tis3d.common.module.execution.instruction.InstructionBitwiseXorImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionHaltAndCatchFire;
import li.cil.tis3d.common.module.execution.instruction.InstructionJump;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpEqualZero;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpGreaterThanZero;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpLessThanZero;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpNotZero;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpRelative;
import li.cil.tis3d.common.module.execution.instruction.InstructionJumpRelativeImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionNegate;
import li.cil.tis3d.common.module.execution.instruction.InstructionSave;
import li.cil.tis3d.common.module.execution.instruction.InstructionSubtract;
import li.cil.tis3d.common.module.execution.instruction.InstructionSubtractImmediate;
import li.cil.tis3d.common.module.execution.instruction.InstructionSwap;
import li.cil.tis3d.common.module.execution.target.Target;

public final class Compiler {
    private static final Pattern PATTERN_COMMENT = Pattern.compile("#.*$");
    private static final Pattern PATTERN_LINE = Pattern.compile("^\\s*(?:(?<label>[^:\\s]+)\\s*:\\s*)?(?:(?<name>\\S+)\\s*(?<arg1>[^,\\s]+)?\\s*,?\\s*(?<arg2>[^,\\s]+)?\\s*(?<excess>.+)?)?\\s*$");
    private static final Instruction INSTRUCTION_NOP = new InstructionAdd(Target.NIL);
    private static final InstructionEmitter EMITTER_MISSING = new InstructionEmitterMissing();
    private static final Map<String, InstructionEmitter> EMITTER_MAP;

    public static void compile(Iterable<String> code, MachineState state) throws ParseException {
        state.clear();
        String[] lines = (String[])Iterables.toArray(code, String.class);
        if (lines.length > Settings.maxLinesPerProgram) {
            throw new ParseException("tis3d.compiler.tooManyLines", Settings.maxLinesPerProgram, 0, 0);
        }
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            lines[lineNumber] = lines[lineNumber].toUpperCase(Locale.ENGLISH);
        }
        state.code = lines;
        try {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
                if (lines[lineNumber].length() > Settings.maxColumnsPerLine) {
                    throw new ParseException("tis3d.compiler.tooManyColumns", lineNumber, Settings.maxColumnsPerLine, Settings.maxColumnsPerLine);
                }
                Matcher commentMatcher = PATTERN_COMMENT.matcher(lines[lineNumber]);
                String line = commentMatcher.replaceFirst("");
                Matcher lineMatcher = PATTERN_LINE.matcher(line);
                if (!lineMatcher.matches()) {
                    throw new ParseException("tis3d.compiler.invalidFormat", lineNumber, 0, 0);
                }
                Compiler.parseLabel(lineMatcher, state, lineNumber);
                Compiler.parseInstruction(lineMatcher, state, lineNumber, validators);
            }
            for (Validator validator : validators) {
                validator.accept(state);
            }
        }
        catch (ParseException e) {
            state.clear();
            state.code = lines;
            throw e;
        }
    }

    private static void parseLabel(Matcher matcher, MachineState state, int lineNumber) throws ParseException {
        String label = matcher.group("label");
        if (label == null) {
            return;
        }
        if (state.labels.containsKey(label)) {
            throw new ParseException("tis3d.compiler.labelDuplicate", lineNumber, matcher.start("label"), matcher.end("label"));
        }
        state.labels.put(label, state.instructions.size());
    }

    private static void parseInstruction(Matcher matcher, MachineState state, int lineNumber, List<Validator> validators) throws ParseException {
        String name = matcher.group("name");
        if (name == null) {
            return;
        }
        Instruction instruction = EMITTER_MAP.getOrDefault(name, EMITTER_MISSING).compile(matcher, lineNumber, validators);
        state.lineNumbers.put(state.instructions.size(), lineNumber);
        state.instructions.add(instruction);
    }

    private static void addInstructionEmitter(ImmutableMap.Builder<String, InstructionEmitter> builder, InstructionEmitter emitter) {
        builder.put((Object)emitter.getInstructionName(), (Object)emitter);
    }

    private Compiler() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterUnary("NOP", () -> INSTRUCTION_NOP));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterUnary("HCF", InstructionHaltAndCatchFire::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterLabel("JMP", InstructionJump::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterLabel("JEZ", InstructionJumpEqualZero::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterLabel("JGZ", InstructionJumpGreaterThanZero::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterLabel("JLZ", InstructionJumpLessThanZero::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterLabel("JNZ", InstructionJumpNotZero::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterTargetOrImmediate("JRO", InstructionJumpRelative::new, InstructionJumpRelativeImmediate::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterMove());
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterUnary("SAV", () -> InstructionSave.INSTANCE));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterUnary("SWP", () -> InstructionSwap.INSTANCE));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterUnary("NEG", () -> InstructionNegate.INSTANCE));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterTargetOrImmediate("ADD", InstructionAdd::new, InstructionAddImmediate::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterTargetOrImmediate("SUB", InstructionSubtract::new, InstructionSubtractImmediate::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterUnary("NOT", () -> InstructionBitwiseNot.INSTANCE));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterTargetOrImmediate("AND", InstructionBitwiseAnd::new, InstructionBitwiseAndImmediate::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterTargetOrImmediate("OR", InstructionBitwiseOr::new, InstructionBitwiseOrImmediate::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterTargetOrImmediate("XOR", InstructionBitwiseXor::new, InstructionBitwiseXorImmediate::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterTargetOrImmediate("SHL", InstructionBitwiseShiftLeft::new, InstructionBitwiseShiftLeftImmediate::new));
        Compiler.addInstructionEmitter((ImmutableMap.Builder<String, InstructionEmitter>)builder, new InstructionEmitterTargetOrImmediate("SHR", InstructionBitwiseShiftRight::new, InstructionBitwiseShiftRightImmediate::new));
        EMITTER_MAP = builder.build();
    }
}

