/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.compiler.instruction;

import java.util.regex.Matcher;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitter;
import li.cil.tis3d.common.module.execution.target.Target;

abstract class AbstractInstructionEmitter
implements InstructionEmitter {
    AbstractInstructionEmitter() {
    }

    protected static void checkExcess(int lineNumber, Matcher matcher, String name) throws ParseException {
        int start = matcher.start(name);
        if (start >= 0) {
            throw new ParseException("tis3d.compiler.parameterOverflow", lineNumber, start, matcher.end());
        }
    }

    protected static String checkArg(int lineNumber, Matcher matcher, String name, String previous) throws ParseException {
        String arg = matcher.group(name);
        if (arg == null) {
            throw new ParseException("tis3d.compiler.parameterUnderflow", lineNumber, matcher.end(previous) + 1, matcher.end(previous) + 1);
        }
        return arg;
    }

    protected static Target checkTarget(int lineNumber, String name, int start, int end) throws ParseException {
        try {
            Target target = Enum.valueOf(Target.class, name);
            if (!Target.VALID_TARGETS.contains((Object)target)) {
                throw new ParseException("tis3d.compiler.parameterInvalid", lineNumber, start, end);
            }
            return target;
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("tis3d.compiler.parameterInvalid", lineNumber, start, end);
        }
    }

    protected static Object checkTargetOrNumber(int lineNumber, String name, int start, int end) throws ParseException {
        try {
            Target target = Enum.valueOf(Target.class, name);
            if (!Target.VALID_TARGETS.contains((Object)target)) {
                throw new ParseException("tis3d.compiler.parameterInvalid", lineNumber, start, end);
            }
            return target;
        }
        catch (IllegalArgumentException ex) {
            try {
                return Integer.decode(name).shortValue();
            }
            catch (NumberFormatException ignored) {
                throw new ParseException("tis3d.compiler.parameterInvalid", lineNumber, start, end);
            }
        }
    }
}

