/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.compiler.instruction;

import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.compiler.Validator;
import li.cil.tis3d.common.module.execution.compiler.instruction.AbstractInstructionEmitter;
import li.cil.tis3d.common.module.execution.instruction.Instruction;

public final class InstructionEmitterLabel
extends AbstractInstructionEmitter {
    private final String name;
    private final Function<String, Instruction> constructor;

    public InstructionEmitterLabel(String name, Function<String, Instruction> constructor) {
        this.name = name;
        this.constructor = constructor;
    }

    @Override
    public String getInstructionName() {
        return this.name;
    }

    @Override
    public Instruction compile(Matcher matcher, int lineNumber, List<Validator> validators) throws ParseException {
        String label = InstructionEmitterLabel.checkArg(lineNumber, matcher, "arg1", "name");
        InstructionEmitterLabel.checkExcess(lineNumber, matcher, "arg2");
        validators.add(state -> InstructionEmitterLabel.validateLabel(state, label, matcher, lineNumber));
        return this.constructor.apply(label);
    }

    private static void validateLabel(MachineState state, String label, Matcher matcher, int lineNumber) throws ParseException {
        if (!state.labels.containsKey(label)) {
            throw new ParseException("tis3d.compiler.labelNotFound", lineNumber, matcher.start("arg1"), matcher.end("arg1"));
        }
    }
}

