/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.tileentity;

import java.util.ArrayDeque;
import java.util.HashSet;
import javax.annotation.Nullable;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.BlockChangeAware;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.integration.redstone.RedstoneIntegration;
import li.cil.tis3d.common.inventory.InventoryCasing;
import li.cil.tis3d.common.inventory.SidedInventoryProxy;
import li.cil.tis3d.common.machine.CasingImpl;
import li.cil.tis3d.common.machine.CasingProxy;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageCasingState;
import li.cil.tis3d.common.tileentity.TileEntityComputer;
import li.cil.tis3d.common.tileentity.TileEntityController;
import li.cil.tis3d.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class TileEntityCasing
extends TileEntityComputer
implements SidedInventoryProxy,
CasingProxy,
InfraredReceiver {
    private final InventoryCasing inventory = new InventoryCasing(this);
    private final CasingImpl casing = new CasingImpl(this);
    private static final String TAG_INVENTORY = "inventory";
    private static final String TAG_CASING = "casing";
    private static final String TAG_ENABLED = "enabled";
    private TileEntityController controller;
    private boolean isEnabled;
    private boolean redstoneDirty = true;

    @Nullable
    public TileEntityController getController() {
        return this.controller;
    }

    public void setController(@Nullable TileEntityController controller) {
        this.controller = controller;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEnabled(boolean value) {
        this.isEnabled = value;
    }

    @Override
    public void scheduleScan() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.getController() != null) {
            this.getController().scheduleScan();
        } else {
            TileEntityController controller = this.findController();
            if (controller != null) {
                controller.scheduleScan();
            }
        }
    }

    public void onEnabled() {
        if (this.isEnabled) {
            return;
        }
        this.isEnabled = true;
        this.sendState();
        this.casing.onEnabled();
    }

    public void onDisabled() {
        if (!this.isEnabled) {
            return;
        }
        this.isEnabled = false;
        this.sendState();
        this.casing.onDisabled();
    }

    public void stepRedstone() {
        if (!this.redstoneDirty) {
            return;
        }
        this.redstoneDirty = false;
        for (Face face : Face.VALUES) {
            Module module = this.getCasing().getModule(face);
            if (module instanceof Redstone) {
                Redstone redstone = (Redstone)module;
                short signal = (short)RedstoneIntegration.INSTANCE.getRedstoneInput(redstone);
                redstone.setRedstoneInput(signal);
            }
            if (!(module instanceof BundledRedstone)) continue;
            BundledRedstone bundledRedstone = (BundledRedstone)module;
            for (int channel = 0; channel < 16; ++channel) {
                short signal = (short)RedstoneIntegration.INSTANCE.getBundledRedstoneInput(bundledRedstone, channel);
                bundledRedstone.setBundledRedstoneInput(channel, signal);
            }
        }
    }

    public void stepModules() {
        this.casing.stepModules();
    }

    public void setModule(Face face, Module module) {
        this.casing.setModule(face, module);
    }

    public void lock(ItemStack stack) {
        this.casing.lock(stack);
    }

    public void unlock(ItemStack stack) {
        this.casing.unlock(stack);
    }

    public void notifyModulesOfBlockChange(Block neighborBlock) {
        for (Face face : Face.VALUES) {
            Module module = this.getModule(face);
            if (!(module instanceof BlockChangeAware)) continue;
            ((BlockChangeAware)module).onNeighborBlockChange(neighborBlock);
        }
    }

    @Override
    protected void setNeighbor(Face face, @Nullable TileEntityComputer neighbor) {
        super.setNeighbor(face, neighbor);
        if (this.neighbors[face.ordinal()] != null) {
            InventoryUtils.drop(this.func_145831_w(), this.func_174877_v(), this, face.ordinal(), this.func_70297_j_(), Face.toEnumFacing(face));
        }
        if (neighbor instanceof TileEntityController && this.getController() != neighbor && this.getController() != null) {
            this.getController().scheduleScan();
        }
    }

    @Override
    public void onWriteComplete(Face sendingFace, Port sendingPort) {
        super.onWriteComplete(sendingFace, sendingPort);
        Module module = this.getModule(sendingFace);
        if (module != null) {
            module.onWriteComplete(sendingPort);
        }
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double maxDistance = 64.0;
        return player.func_174831_c(this.field_174879_c) <= 64.0;
    }

    @Override
    public ISidedInventory getInventory() {
        return this.inventory;
    }

    @Override
    public Casing getCasing() {
        return this.casing;
    }

    @Override
    public void onInfraredPacket(InfraredPacket packet, RayTraceResult hit) {
        Module module = this.getModule(Face.fromEnumFacing(hit.field_178784_b));
        if (module instanceof InfraredReceiver) {
            ((InfraredReceiver)((Object)module)).onInfraredPacket(packet, hit);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.func_145831_w().field_72995_K) {
            this.onDisabled();
        }
        this.dispose();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.dispose();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.load(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtIn) {
        NBTTagCompound nbt = super.func_189515_b(nbtIn);
        this.save(nbt);
        return nbt;
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        this.load(nbt);
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.save(nbt);
        return nbt;
    }

    public double func_145833_n() {
        return 2304.0;
    }

    private TileEntityController findController() {
        HashSet<TileEntity> processed = new HashSet<TileEntity>();
        ArrayDeque<TileEntity> queue = new ArrayDeque<TileEntity>();
        int casings = 0;
        processed.add(this);
        queue.add(this);
        while (!queue.isEmpty()) {
            TileEntity tileEntity = (TileEntity)queue.remove();
            if (tileEntity.func_145837_r()) continue;
            if (tileEntity instanceof TileEntityController) {
                return (TileEntityController)tileEntity;
            }
            if (++casings > Settings.maxCasingsPerController) {
                this.onDisabled();
                return null;
            }
            if (TileEntityController.addNeighbors(this.func_145831_w(), tileEntity, processed, queue)) continue;
            return null;
        }
        this.onDisabled();
        return null;
    }

    public void markRedstoneDirty() {
        this.redstoneDirty = true;
    }

    private void sendState() {
        MessageCasingState message = new MessageCasingState(this, this.isEnabled);
        Network.INSTANCE.getWrapper().sendToDimension((IMessage)message, this.func_145831_w().field_73011_w.getDimension());
    }

    private void dispose() {
        if (this.getController() != null) {
            this.getController().scheduleScan();
        }
        this.casing.onDisposed();
    }

    private void load(NBTTagCompound nbt) {
        NBTTagCompound inventoryNbt = nbt.func_74775_l(TAG_INVENTORY);
        this.inventory.readFromNBT(inventoryNbt);
        NBTTagCompound casingNbt = nbt.func_74775_l(TAG_CASING);
        this.casing.readFromNBT(casingNbt);
        this.isEnabled = nbt.func_74767_n(TAG_ENABLED);
    }

    private void save(NBTTagCompound nbt) {
        NBTTagCompound inventoryNbt = new NBTTagCompound();
        this.inventory.writeToNBT(inventoryNbt);
        nbt.func_74782_a(TAG_INVENTORY, (NBTBase)inventoryNbt);
        NBTTagCompound casingNbt = new NBTTagCompound();
        this.casing.writeToNBT(casingNbt);
        nbt.func_74782_a(TAG_CASING, (NBTBase)casingNbt);
        nbt.func_74757_a(TAG_ENABLED, this.isEnabled());
    }
}

