/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.tileentity;

import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.machine.PipeHost;
import li.cil.tis3d.common.machine.PipeImpl;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityComputer
extends TileEntity
implements PipeHost {
    private final PipeImpl[] pipes = new PipeImpl[Face.VALUES.length * Port.VALUES.length];
    private static final Face[][] FACE_MAPPING = new Face[][]{{Face.X_NEG, Face.X_POS, Face.Z_POS, Face.Z_NEG}, {Face.X_POS, Face.X_NEG, Face.Z_POS, Face.Z_NEG}, {Face.X_POS, Face.X_NEG, Face.Y_POS, Face.Y_NEG}, {Face.X_NEG, Face.X_POS, Face.Y_POS, Face.Y_NEG}, {Face.Z_NEG, Face.Z_POS, Face.Y_POS, Face.Y_NEG}, {Face.Z_POS, Face.Z_NEG, Face.Y_POS, Face.Y_NEG}};
    private static final Port[][] PORT_MAPPING = new Port[][]{{Port.DOWN, Port.DOWN, Port.DOWN, Port.DOWN}, {Port.UP, Port.UP, Port.UP, Port.UP}, {Port.RIGHT, Port.LEFT, Port.DOWN, Port.DOWN}, {Port.RIGHT, Port.LEFT, Port.UP, Port.UP}, {Port.RIGHT, Port.LEFT, Port.RIGHT, Port.LEFT}, {Port.RIGHT, Port.LEFT, Port.LEFT, Port.RIGHT}};
    private static final String TAG_PIPES = "pipes";
    protected final TileEntityComputer[] neighbors = new TileEntityComputer[Face.VALUES.length];
    protected final Forwarder[] forwarders = new Forwarder[Face.VALUES.length];

    protected TileEntityComputer() {
        for (Face face : Face.VALUES) {
            for (Port port : Port.VALUES) {
                this.pipes[TileEntityComputer.pack((Face)face, (Port)port)] = new PipeImpl(this, face, TileEntityComputer.mapFace(face, port), TileEntityComputer.mapSide(face, port));
            }
        }
    }

    public void stepPipes() {
        for (PipeImpl pipe : this.pipes) {
            pipe.step();
        }
    }

    public void stepForwarders() {
        for (Forwarder forwarder : this.forwarders) {
            if (forwarder == null) continue;
            forwarder.step();
        }
    }

    public Pipe[] getPipes() {
        return this.pipes;
    }

    public Pipe getReceivingPipe(Face face, Port port) {
        return this.pipes[TileEntityComputer.pack(face, port)];
    }

    public Pipe getSendingPipe(Face face, Port port) {
        return this.pipes[TileEntityComputer.packMapped(face, port)];
    }

    @Override
    @Nullable
    public World getPipeHostWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPipeHostPosition() {
        return this.func_174877_v();
    }

    @Override
    public void onWriteComplete(Face sendingFace, Port sendingPort) {
        Forwarder forwarder = this.forwarders[sendingFace.ordinal()];
        if (forwarder != null) {
            forwarder.onWriteComplete(sendingPort);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList pipesNbt = nbt.func_150295_c(TAG_PIPES, 10);
        int pipeCount = Math.min(pipesNbt.func_74745_c(), this.pipes.length);
        for (int i = 0; i < pipeCount; ++i) {
            this.pipes[i].readFromNBT(pipesNbt.func_150305_b(i));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtIn) {
        NBTTagCompound nbt = super.func_189515_b(nbtIn);
        NBTTagList pipesNbt = new NBTTagList();
        for (PipeImpl pipe : this.pipes) {
            NBTTagCompound portNbt = new NBTTagCompound();
            pipe.writeToNBT(portNbt);
            pipesNbt.func_74742_a((NBTBase)portNbt);
        }
        nbt.func_74782_a(TAG_PIPES, (NBTBase)pipesNbt);
        return nbt;
    }

    protected abstract void scheduleScan();

    public void checkNeighbors() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos neighborPos = this.func_174877_v().func_177972_a(facing);
            if (this.func_145831_w().func_175667_e(neighborPos)) {
                TileEntity tileEntity = this.func_145831_w().func_175625_s(neighborPos);
                if (tileEntity instanceof TileEntityComputer) {
                    this.setNeighbor(Face.fromEnumFacing(facing), (TileEntityComputer)tileEntity);
                    continue;
                }
                this.setNeighbor(Face.fromEnumFacing(facing), null);
                continue;
            }
            this.setNeighbor(Face.fromEnumFacing(facing), null);
        }
    }

    protected void setNeighbor(Face face, @Nullable TileEntityComputer neighbor) {
        TileEntityComputer oldNeighbor = this.neighbors[face.ordinal()];
        if (neighbor != oldNeighbor) {
            this.neighbors[face.ordinal()] = neighbor;
            this.scheduleScan();
        }
        if (neighbor == null) {
            this.forwarders[face.ordinal()] = null;
        } else if (this.forwarders[face.ordinal()] == null) {
            Forwarder forwarder = new Forwarder(this, face);
            Forwarder neighborForwarder = new Forwarder(neighbor, face.getOpposite());
            forwarder.setSink(neighborForwarder);
            neighborForwarder.setSink(forwarder);
            this.forwarders[face.ordinal()] = forwarder;
            neighbor.forwarders[face.getOpposite().ordinal()] = neighborForwarder;
        }
    }

    private static Face mapFace(Face face, Port port) {
        return FACE_MAPPING[face.ordinal()][port.ordinal()];
    }

    private static Port mapSide(Face face, Port port) {
        return PORT_MAPPING[face.ordinal()][port.ordinal()];
    }

    private static int pack(Face face, Port port) {
        return face.ordinal() * Port.VALUES.length + port.ordinal();
    }

    private static int packMapped(Face face, Port port) {
        return TileEntityComputer.mapFace(face, port).ordinal() * Port.VALUES.length + TileEntityComputer.mapSide(face, port).ordinal();
    }

    private static final class Forwarder {
        private final TileEntityComputer computer;
        private final Face face;
        private Forwarder other;

        private Forwarder(TileEntityComputer computer, Face face) {
            this.computer = computer;
            this.face = face;
        }

        public void setSink(Forwarder other) {
            this.other = other;
        }

        public void step() {
            assert (!this.computer.func_145831_w().field_72995_K);
            for (Port port : Port.VALUES) {
                this.beginForwarding(port);
            }
        }

        public void onWriteComplete(Port port) {
            assert (!this.computer.func_145831_w().field_72995_K);
            this.beginForwarding(port);
        }

        private void beginForwarding(Port port) {
            Pipe receivingPipe = this.computer.getReceivingPipe(this.face, port);
            Pipe sendingPipe = this.other.computer.getSendingPipe(this.other.face, Forwarder.flipSide(port));
            if (sendingPipe.isReading() && !sendingPipe.isWriting()) {
                if (!receivingPipe.isReading()) {
                    receivingPipe.beginRead();
                }
                if (receivingPipe.canTransfer()) {
                    sendingPipe.beginWrite(receivingPipe.read());
                }
            } else if (receivingPipe.isReading()) {
                receivingPipe.cancelRead();
            }
        }

        private static Port flipSide(Port port) {
            return port == Port.LEFT || port == Port.RIGHT ? port.getOpposite() : port;
        }
    }
}

