/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.tileentity;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import li.cil.tis3d.api.machine.HaltAndCatchFireException;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.machine.CasingProxy;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageHaltAndCatchFire;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import li.cil.tis3d.common.tileentity.TileEntityComputer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class TileEntityController
extends TileEntityComputer
implements ITickable {
    private static final int COOLDOWN_HCF = 60;
    private final List<TileEntityCasing> casings = new ArrayList<TileEntityCasing>(Settings.maxCasingsPerController);
    private ControllerState state = ControllerState.SCANNING;
    private static final String TAG_HCF_COOLDOWN = "hcfCooldown";
    private boolean forceStep;
    private int hcfCooldown = 0;

    public ControllerState getState() {
        return this.state;
    }

    @Override
    public void scheduleScan() {
        this.state = ControllerState.SCANNING;
    }

    public void forceStep() {
        if (this.state == ControllerState.RUNNING) {
            this.forceStep = true;
            this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.2f, 0.8f + this.func_145831_w().field_73012_v.nextFloat() * 0.1f);
        }
    }

    public void haltAndCatchFire() {
        if (!this.func_145831_w().field_72995_K) {
            this.state = ControllerState.READY;
            this.casings.forEach(TileEntityCasing::onDisabled);
            MessageHaltAndCatchFire message = new MessageHaltAndCatchFire(this.func_145831_w(), this.func_174877_v());
            NetworkRegistry.TargetPoint target = Network.getTargetPoint(this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 32);
            Network.INSTANCE.getWrapper().sendToAllAround((IMessage)message, target);
        }
        this.hcfCooldown = 60;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.casings.forEach(TileEntityCasing::onDisabled);
        for (TileEntityCasing casing : this.casings) {
            casing.setController(null);
        }
        this.casings.clear();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos neighborPos = this.func_174877_v().func_177972_a(facing);
            if (!this.func_145831_w().func_175667_e(neighborPos)) continue;
            TileEntity tileEntity = this.func_145831_w().func_175625_s(neighborPos);
            if (tileEntity instanceof TileEntityController) {
                TileEntityController controller = (TileEntityController)tileEntity;
                controller.scheduleScan();
                continue;
            }
            if (!(tileEntity instanceof TileEntityCasing)) continue;
            TileEntityCasing casing = (TileEntityCasing)tileEntity;
            casing.scheduleScan();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        for (TileEntityCasing casing : this.casings) {
            casing.setController(null);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hcfCooldown = nbt.func_74762_e(TAG_HCF_COOLDOWN);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtIn) {
        NBTTagCompound nbt = super.func_189515_b(nbtIn);
        nbt.func_74768_a(TAG_HCF_COOLDOWN, this.hcfCooldown);
        return nbt;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            if (this.hcfCooldown > 0) {
                --this.hcfCooldown;
                World world = this.func_145831_w();
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos neighborPos = this.func_174877_v().func_177972_a(facing);
                    IBlockState neighborState = this.func_145831_w().func_180495_p(neighborPos);
                    if (world.func_180495_p(neighborPos).func_177230_c().func_149662_c(neighborState) || world.field_73012_v.nextFloat() > 0.25f) continue;
                    float ox = (float)neighborPos.func_177958_n() + world.field_73012_v.nextFloat();
                    float oy = (float)neighborPos.func_177956_o() + world.field_73012_v.nextFloat();
                    float oz = (float)neighborPos.func_177952_p() + world.field_73012_v.nextFloat();
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)ox, (double)oy, (double)oz, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            return;
        }
        if (this.hcfCooldown > 0) {
            --this.hcfCooldown;
            return;
        }
        if (this.state == ControllerState.SCANNING) {
            this.scan();
        }
        if (this.state != ControllerState.READY && this.state != ControllerState.RUNNING) {
            return;
        }
        int power = this.computePower();
        if (this.state == ControllerState.READY) {
            if (power < 1) {
                return;
            }
            this.state = ControllerState.RUNNING;
            this.casings.forEach(TileEntityCasing::onEnabled);
        }
        if (this.state == ControllerState.RUNNING) {
            boolean bl = this.forceStep = this.forceStep && power == 1;
            if (!this.func_145831_w().func_175640_z(this.func_174877_v())) {
                this.state = ControllerState.READY;
                this.casings.forEach(TileEntityCasing::onDisabled);
            } else if (power > 1 || this.forceStep) {
                this.casings.forEach(TileEntityCasing::stepRedstone);
                try {
                    if (power < 15) {
                        int delay = 15 - power;
                        if (this.func_145831_w().func_82737_E() % (long)delay == 0L || this.forceStep) {
                            this.step();
                        }
                    } else {
                        int steps = power / 15;
                        for (int step = 0; step < steps; ++step) {
                            this.step();
                        }
                    }
                }
                catch (HaltAndCatchFireException e) {
                    this.haltAndCatchFire();
                }
            }
            this.forceStep = false;
        }
    }

    static boolean addNeighbors(World world, TileEntity tileEntity, Set<TileEntity> processed, Queue<TileEntity> queue) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos neighborPos = tileEntity.func_174877_v().func_177972_a(facing);
            if (!world.func_175667_e(neighborPos)) {
                return false;
            }
            TileEntity neighborTileEntity = world.func_175625_s(neighborPos);
            if (neighborTileEntity == null || !processed.add(neighborTileEntity) || !(neighborTileEntity instanceof TileEntityController) && !(neighborTileEntity instanceof TileEntityCasing)) continue;
            queue.add(neighborTileEntity);
        }
        return true;
    }

    private void scan() {
        HashSet<TileEntity> processed = new HashSet<TileEntity>();
        ArrayDeque<TileEntity> queue = new ArrayDeque<TileEntity>();
        ArrayList<TileEntityCasing> newCasings = new ArrayList<TileEntityCasing>(Settings.maxCasingsPerController);
        processed.add(this);
        queue.add(this);
        while (!queue.isEmpty()) {
            TileEntity tileEntity = (TileEntity)queue.remove();
            if (tileEntity instanceof TileEntityController) {
                if (tileEntity == this) {
                    if (TileEntityController.addNeighbors(this.func_145831_w(), tileEntity, processed, queue)) continue;
                    this.clear(ControllerState.INCOMPLETE);
                    return;
                }
                this.clear(ControllerState.MULTIPLE_CONTROLLERS);
                return;
            }
            if (newCasings.size() + 1 > Settings.maxCasingsPerController) {
                this.clear(ControllerState.TOO_COMPLEX);
                return;
            }
            TileEntityCasing casing = (TileEntityCasing)tileEntity;
            newCasings.add(casing);
            TileEntityController.addNeighbors(this.func_145831_w(), casing, processed, queue);
        }
        if (newCasings.stream().anyMatch(c -> !c.func_145830_o())) {
            return;
        }
        this.casings.removeAll(newCasings);
        this.casings.forEach(c -> c.setController(null));
        this.casings.forEach(TileEntityCasing::scheduleScan);
        this.casings.clear();
        this.casings.addAll(newCasings);
        this.casings.forEach(c -> c.setController(this));
        this.casings.forEach(TileEntityComputer::checkNeighbors);
        this.checkNeighbors();
        this.casings.sort(Comparator.comparing(CasingProxy::getPosition));
        this.state = ControllerState.READY;
    }

    private int computePower() {
        int acc = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            acc += Math.max(0, Math.min(15, this.func_145831_w().func_175651_c(this.func_174877_v().func_177972_a(facing), facing)));
        }
        return acc;
    }

    private void step() {
        this.casings.forEach(TileEntityCasing::stepModules);
        this.casings.forEach(TileEntityComputer::stepPipes);
        this.casings.forEach(TileEntityComputer::stepForwarders);
        this.stepPipes();
        this.stepForwarders();
    }

    private void clear(ControllerState toState) {
        for (TileEntityCasing casing : this.casings) {
            casing.setController(null);
        }
        if (toState != ControllerState.INCOMPLETE) {
            this.casings.forEach(TileEntityCasing::onDisabled);
        }
        this.casings.clear();
        this.state = toState;
    }

    public static enum ControllerState {
        SCANNING,
        MULTIPLE_CONTROLLERS,
        TOO_COMPLEX,
        INCOMPLETE,
        READY,
        RUNNING;

    }
}

