/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.util;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class Raytracing {
    public static RayTraceResult intersectIgnoringLiquids(World world, BlockPos position, Vec3d start, Vec3d end) {
        IBlockState state = world.func_180495_p(position);
        Block block = state.func_177230_c();
        if (block.func_180646_a(state, world, position) != null && block.func_176209_a(state, false)) {
            return block.func_180636_a(state, world, position, start, end);
        }
        return null;
    }

    public static RayTraceResult intersectIgnoringTransparent(World world, BlockPos position, Vec3d start, Vec3d end) {
        IBlockState state = world.func_180495_p(position);
        Block block = state.func_177230_c();
        if (!(block.func_149688_o(state).func_76230_c() && block.func_149688_o(state).func_76218_k() && block.func_149688_o(state).func_76228_b())) {
            return null;
        }
        if (block.func_180646_a(state, world, position) != null && block.func_176209_a(state, false)) {
            return block.func_180636_a(state, world, position, start, end);
        }
        return null;
    }

    public static RayTraceResult raytrace(World world, Vec3d start, Vec3d end) {
        return Raytracing.raytrace(world, start, end, Raytracing::intersectIgnoringLiquids);
    }

    public static RayTraceResult raytrace(World world, Vec3d start, Vec3d end, CollisionDetector callback) {
        int stepY;
        int stepX;
        int startPosX = MathHelper.func_76128_c((double)start.field_72450_a);
        int startPosY = MathHelper.func_76128_c((double)start.field_72448_b);
        int startPosZ = MathHelper.func_76128_c((double)start.field_72449_c);
        int endPosX = MathHelper.func_76128_c((double)end.field_72450_a);
        int endPosY = MathHelper.func_76128_c((double)end.field_72448_b);
        int endPosZ = MathHelper.func_76128_c((double)end.field_72449_c);
        int n = endPosX > startPosX ? 1 : (stepX = endPosX < startPosX ? -1 : 0);
        int n2 = endPosY > startPosY ? 1 : (stepY = endPosY < startPosY ? -1 : 0);
        int stepZ = endPosZ > startPosZ ? 1 : (endPosZ < startPosZ ? -1 : 0);
        int gxp = startPosX + (endPosX > startPosX ? 1 : 0);
        int gyp = startPosY + (endPosY > startPosY ? 1 : 0);
        int gzp = startPosZ + (endPosZ > startPosZ ? 1 : 0);
        double vx = end.field_72450_a == start.field_72450_a ? 1.0 : end.field_72450_a - start.field_72450_a;
        double vy = end.field_72448_b == start.field_72448_b ? 1.0 : end.field_72448_b - start.field_72448_b;
        double vz = end.field_72449_c == start.field_72449_c ? 1.0 : end.field_72449_c - start.field_72449_c;
        double vxvy = vx * vy;
        double vxvz = vx * vz;
        double vyvz = vy * vz;
        double scaledErrorX = (double)stepX * vyvz;
        double scaledErrorY = (double)stepY * vxvz;
        double scaledErrorZ = (double)stepZ * vxvy;
        double errorX = ((double)gxp - start.field_72450_a) * vyvz;
        double errorY = ((double)gyp - start.field_72448_b) * vxvz;
        double errorZ = ((double)gzp - start.field_72449_c) * vxvy;
        int currentPosX = startPosX;
        int currentPosY = startPosY;
        int currentPosZ = startPosZ;
        int emergencyExit = 200;
        while (--emergencyExit > 0) {
            BlockPos position = new BlockPos(currentPosX, currentPosY, currentPosZ);
            RayTraceResult hit = callback.intersect(world, position, start, end);
            if (hit != null && hit.field_72313_a != RayTraceResult.Type.MISS) {
                return hit;
            }
            if (currentPosX == endPosX && currentPosY == endPosY && currentPosZ == endPosZ) {
                return null;
            }
            double xr = Math.abs(errorX);
            double yr = Math.abs(errorY);
            double zr = Math.abs(errorZ);
            if (stepX != 0 && (stepY == 0 || xr < yr) && (stepZ == 0 || xr < zr)) {
                currentPosX += stepX;
                errorX += scaledErrorX;
                continue;
            }
            if (stepY != 0 && (stepZ == 0 || yr < zr)) {
                currentPosY += stepY;
                errorY += scaledErrorY;
                continue;
            }
            if (stepZ == 0) continue;
            currentPosZ += stepZ;
            errorZ += scaledErrorZ;
        }
        return null;
    }

    private Raytracing() {
    }

    @FunctionalInterface
    public static interface CollisionDetector {
        public RayTraceResult intersect(World var1, BlockPos var2, Vec3d var3, Vec3d var4);
    }
}

