/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.asm;

import com.google.common.collect.Lists;
import com.google.common.reflect.ClassPath;
import elec332.core.asm.ASMHelper;
import elec332.core.asm.IASMClassTransformer;
import elec332.core.asm.asmload.ASMHooks;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;

public final class ASMLoader
implements IClassTransformer {
    private static final List<IASMClassTransformer> classTransformers = Lists.newArrayList();
    private static final String asmHooksClass = ASMHelper.getInternalName(ASMHooks.class);
    private static final String asmHooksClassClient = ASMHelper.getInternalName(ASMHooks.Client.class);

    public ASMLoader() {
        try {
            ArrayList list = Lists.newArrayList((Iterable)ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getTopLevelClasses("elec332.core.asm.asmload"));
            list.addAll(ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getTopLevelClasses("elec332.asmload"));
            for (ClassPath.ClassInfo classInfo : list) {
                Class clazz = classInfo.load();
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || !IASMClassTransformer.class.isAssignableFrom(clazz)) continue;
                classTransformers.add((IASMClassTransformer)clazz.newInstance());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("ElecCore-ASM failed to load properly.", e);
        }
    }

    public byte[] transform(String obf, String deobf, byte[] bytes) {
        for (IASMClassTransformer classTransformer : classTransformers) {
            if (!classTransformer.getDeObfuscatedClassName().equals(deobf)) continue;
            bytes = classTransformer.transformClass(bytes);
        }
        return bytes;
    }

    public static String getAsmHooksClass() {
        return asmHooksClass;
    }

    public static String getAsmHooksClassClient() {
        return asmHooksClassClient;
    }
}

