/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client;

import elec332.core.client.ITessellator;
import elec332.core.client.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBlocks {
    public TextureAtlasSprite overrideBlockTexture;
    public boolean flipTexture;
    public boolean field_152631_f;
    public boolean renderFromInside = false;
    public double renderMinX;
    public double renderMaxX;
    public double renderMinY;
    public double renderMaxY;
    public double renderMinZ;
    public double renderMaxZ;
    public boolean lockBlockBounds;
    public boolean partialRenderBounds;
    public final Minecraft minecraftRB = Minecraft.func_71410_x();
    public int uvRotateEast;
    public int uvRotateWest;
    public int uvRotateSouth;
    public int uvRotateNorth;
    public int uvRotateTop;
    public int uvRotateBottom;
    public boolean enableAO;
    public int brightnessTopLeft;
    public int brightnessBottomLeft;
    public int brightnessBottomRight;
    public int brightnessTopRight;
    public float colorRedTopLeft;
    public float colorRedBottomLeft;
    public float colorRedBottomRight;
    public float colorRedTopRight;
    public float colorGreenTopLeft;
    public float colorGreenBottomLeft;
    public float colorGreenBottomRight;
    public float colorGreenTopRight;
    public float colorBlueTopLeft;
    public float colorBlueBottomLeft;
    public float colorBlueBottomRight;
    public float colorBlueTopRight;
    private ITessellator tessellator = RenderHelper.getTessellator();

    public RenderBlocks() {
        this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public RenderBlocks setTessellator(ITessellator tessellator) {
        this.tessellator = tessellator;
        return this;
    }

    public RenderBlocks resetTessellator() {
        return this.setTessellator(RenderHelper.getTessellator());
    }

    public void setOverrideBlockTexture(TextureAtlasSprite p_147757_1_) {
        this.overrideBlockTexture = p_147757_1_;
    }

    public void clearOverrideBlockTexture() {
        this.overrideBlockTexture = null;
    }

    public boolean hasOverrideBlockTexture() {
        return this.overrideBlockTexture != null;
    }

    public void setRenderFromInside(boolean p_147786_1_) {
        this.renderFromInside = p_147786_1_;
    }

    public void setRenderBounds(double p_147782_1_, double p_147782_3_, double p_147782_5_, double p_147782_7_, double p_147782_9_, double p_147782_11_) {
        if (!this.lockBlockBounds) {
            this.renderMinX = p_147782_1_;
            this.renderMaxX = p_147782_7_;
            this.renderMinY = p_147782_3_;
            this.renderMaxY = p_147782_9_;
            this.renderMinZ = p_147782_5_;
            this.renderMaxZ = p_147782_11_;
            this.partialRenderBounds = this.minecraftRB.field_71474_y.field_74348_k >= 2 && (this.renderMinX > 0.0 || this.renderMaxX < 1.0 || this.renderMinY > 0.0 || this.renderMaxY < 1.0 || this.renderMinZ > 0.0 || this.renderMaxZ < 1.0);
        }
    }

    public void overrideBlockBounds(double p_147770_1_, double p_147770_3_, double p_147770_5_, double p_147770_7_, double p_147770_9_, double p_147770_11_) {
        this.renderMinX = p_147770_1_;
        this.renderMaxX = p_147770_7_;
        this.renderMinY = p_147770_3_;
        this.renderMaxY = p_147770_9_;
        this.renderMinZ = p_147770_5_;
        this.renderMaxZ = p_147770_11_;
        this.lockBlockBounds = true;
        this.partialRenderBounds = this.minecraftRB.field_71474_y.field_74348_k >= 2 && (this.renderMinX > 0.0 || this.renderMaxX < 1.0 || this.renderMinY > 0.0 || this.renderMaxY < 1.0 || this.renderMinZ > 0.0 || this.renderMaxZ < 1.0);
    }

    public void unlockBlockBounds() {
        this.lockBlockBounds = false;
    }

    public void render(EnumFacing facing, BlockPos pos, TextureAtlasSprite texture) {
        switch (facing) {
            case DOWN: {
                this.renderFaceYNeg(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), texture);
                return;
            }
            case UP: {
                this.renderFaceYPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), texture);
                return;
            }
            case NORTH: {
                this.renderFaceZNeg(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), texture);
                return;
            }
            case SOUTH: {
                this.renderFaceZPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), texture);
                return;
            }
            case WEST: {
                this.renderFaceXNeg(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), texture);
                return;
            }
            case EAST: {
                this.renderFaceXPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), texture);
                return;
            }
        }
    }

    public void renderFaceYNeg(double p_147768_2_, double p_147768_4_, double p_147768_6_, TextureAtlasSprite p_147768_8_) {
        if (this.hasOverrideBlockTexture()) {
            p_147768_8_ = this.overrideBlockTexture;
        }
        double d3 = p_147768_8_.func_94214_a(this.renderMinX * 16.0);
        double d4 = p_147768_8_.func_94214_a(this.renderMaxX * 16.0);
        double d5 = p_147768_8_.func_94207_b(this.renderMinZ * 16.0);
        double d6 = p_147768_8_.func_94207_b(this.renderMaxZ * 16.0);
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = p_147768_8_.func_94209_e();
            d4 = p_147768_8_.func_94212_f();
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d5 = p_147768_8_.func_94206_g();
            d6 = p_147768_8_.func_94210_h();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateBottom == 2) {
            d3 = p_147768_8_.func_94214_a(this.renderMinZ * 16.0);
            d5 = p_147768_8_.func_94207_b(16.0 - this.renderMaxX * 16.0);
            d4 = p_147768_8_.func_94214_a(this.renderMaxZ * 16.0);
            d6 = p_147768_8_.func_94207_b(16.0 - this.renderMinX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateBottom == 1) {
            d3 = p_147768_8_.func_94214_a(16.0 - this.renderMaxZ * 16.0);
            d5 = p_147768_8_.func_94207_b(this.renderMinX * 16.0);
            d4 = p_147768_8_.func_94214_a(16.0 - this.renderMinZ * 16.0);
            d6 = p_147768_8_.func_94207_b(this.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateBottom == 3) {
            d3 = p_147768_8_.func_94214_a(16.0 - this.renderMinX * 16.0);
            d4 = p_147768_8_.func_94214_a(16.0 - this.renderMaxX * 16.0);
            d5 = p_147768_8_.func_94207_b(16.0 - this.renderMinZ * 16.0);
            d6 = p_147768_8_.func_94207_b(16.0 - this.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = p_147768_2_ + this.renderMinX;
        double d12 = p_147768_2_ + this.renderMaxX;
        double d13 = p_147768_4_ + this.renderMinY;
        double d14 = p_147768_6_ + this.renderMinZ;
        double d15 = p_147768_6_ + this.renderMaxZ;
        if (this.renderFromInside) {
            d11 = p_147768_2_ + this.renderMaxX;
            d12 = p_147768_2_ + this.renderMinX;
        }
        if (this.enableAO) {
            this.tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            this.tessellator.setBrightness(this.brightnessTopLeft);
            this.tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            this.tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            this.tessellator.setBrightness(this.brightnessBottomLeft);
            this.tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            this.tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            this.tessellator.setBrightness(this.brightnessBottomRight);
            this.tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            this.tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            this.tessellator.setBrightness(this.brightnessTopRight);
            this.tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        } else {
            this.tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            this.tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            this.tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            this.tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        }
    }

    public void renderFaceYPos(double p_147806_2_, double p_147806_4_, double p_147806_6_, TextureAtlasSprite p_147806_8_) {
        if (this.hasOverrideBlockTexture()) {
            p_147806_8_ = this.overrideBlockTexture;
        }
        double d3 = p_147806_8_.func_94214_a(this.renderMinX * 16.0);
        double d4 = p_147806_8_.func_94214_a(this.renderMaxX * 16.0);
        double d5 = p_147806_8_.func_94207_b(this.renderMinZ * 16.0);
        double d6 = p_147806_8_.func_94207_b(this.renderMaxZ * 16.0);
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = p_147806_8_.func_94209_e();
            d4 = p_147806_8_.func_94212_f();
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d5 = p_147806_8_.func_94206_g();
            d6 = p_147806_8_.func_94210_h();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateTop == 1) {
            d3 = p_147806_8_.func_94214_a(this.renderMinZ * 16.0);
            d5 = p_147806_8_.func_94207_b(16.0 - this.renderMaxX * 16.0);
            d4 = p_147806_8_.func_94214_a(this.renderMaxZ * 16.0);
            d6 = p_147806_8_.func_94207_b(16.0 - this.renderMinX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateTop == 2) {
            d3 = p_147806_8_.func_94214_a(16.0 - this.renderMaxZ * 16.0);
            d5 = p_147806_8_.func_94207_b(this.renderMinX * 16.0);
            d4 = p_147806_8_.func_94214_a(16.0 - this.renderMinZ * 16.0);
            d6 = p_147806_8_.func_94207_b(this.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateTop == 3) {
            d3 = p_147806_8_.func_94214_a(16.0 - this.renderMinX * 16.0);
            d4 = p_147806_8_.func_94214_a(16.0 - this.renderMaxX * 16.0);
            d5 = p_147806_8_.func_94207_b(16.0 - this.renderMinZ * 16.0);
            d6 = p_147806_8_.func_94207_b(16.0 - this.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = p_147806_2_ + this.renderMinX;
        double d12 = p_147806_2_ + this.renderMaxX;
        double d13 = p_147806_4_ + this.renderMaxY;
        double d14 = p_147806_6_ + this.renderMinZ;
        double d15 = p_147806_6_ + this.renderMaxZ;
        if (this.renderFromInside) {
            d11 = p_147806_2_ + this.renderMaxX;
            d12 = p_147806_2_ + this.renderMinX;
        }
        if (this.enableAO) {
            this.tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            this.tessellator.setBrightness(this.brightnessTopLeft);
            this.tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            this.tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            this.tessellator.setBrightness(this.brightnessBottomLeft);
            this.tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            this.tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            this.tessellator.setBrightness(this.brightnessBottomRight);
            this.tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            this.tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            this.tessellator.setBrightness(this.brightnessTopRight);
            this.tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        } else {
            this.tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            this.tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            this.tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            this.tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        }
    }

    public void renderFaceZNeg(double p_147761_2_, double p_147761_4_, double p_147761_6_, TextureAtlasSprite p_147761_8_) {
        double d7;
        if (this.hasOverrideBlockTexture()) {
            p_147761_8_ = this.overrideBlockTexture;
        }
        double d3 = p_147761_8_.func_94214_a(this.renderMinX * 16.0);
        double d4 = p_147761_8_.func_94214_a(this.renderMaxX * 16.0);
        if (this.field_152631_f) {
            d4 = p_147761_8_.func_94214_a((1.0 - this.renderMinX) * 16.0);
            d3 = p_147761_8_.func_94214_a((1.0 - this.renderMaxX) * 16.0);
        }
        double d5 = p_147761_8_.func_94207_b(16.0 - this.renderMaxY * 16.0);
        double d6 = p_147761_8_.func_94207_b(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = p_147761_8_.func_94209_e();
            d4 = p_147761_8_.func_94212_f();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = p_147761_8_.func_94206_g();
            d6 = p_147761_8_.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateEast == 2) {
            d3 = p_147761_8_.func_94214_a(this.renderMinY * 16.0);
            d4 = p_147761_8_.func_94214_a(this.renderMaxY * 16.0);
            d5 = p_147761_8_.func_94207_b(16.0 - this.renderMinX * 16.0);
            d6 = p_147761_8_.func_94207_b(16.0 - this.renderMaxX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateEast == 1) {
            d3 = p_147761_8_.func_94214_a(16.0 - this.renderMaxY * 16.0);
            d4 = p_147761_8_.func_94214_a(16.0 - this.renderMinY * 16.0);
            d5 = p_147761_8_.func_94207_b(this.renderMaxX * 16.0);
            d6 = p_147761_8_.func_94207_b(this.renderMinX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateEast == 3) {
            d3 = p_147761_8_.func_94214_a(16.0 - this.renderMinX * 16.0);
            d4 = p_147761_8_.func_94214_a(16.0 - this.renderMaxX * 16.0);
            d5 = p_147761_8_.func_94207_b(this.renderMaxY * 16.0);
            d6 = p_147761_8_.func_94207_b(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = p_147761_2_ + this.renderMinX;
        double d12 = p_147761_2_ + this.renderMaxX;
        double d13 = p_147761_4_ + this.renderMinY;
        double d14 = p_147761_4_ + this.renderMaxY;
        double d15 = p_147761_6_ + this.renderMinZ;
        if (this.renderFromInside) {
            d11 = p_147761_2_ + this.renderMaxX;
            d12 = p_147761_2_ + this.renderMinX;
        }
        if (this.enableAO) {
            this.tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            this.tessellator.setBrightness(this.brightnessTopLeft);
            this.tessellator.addVertexWithUV(d11, d14, d15, d7, d9);
            this.tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            this.tessellator.setBrightness(this.brightnessBottomLeft);
            this.tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            this.tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            this.tessellator.setBrightness(this.brightnessBottomRight);
            this.tessellator.addVertexWithUV(d12, d13, d15, d8, d10);
            this.tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            this.tessellator.setBrightness(this.brightnessTopRight);
            this.tessellator.addVertexWithUV(d11, d13, d15, d4, d6);
        } else {
            this.tessellator.addVertexWithUV(d11, d14, d15, d7, d9);
            this.tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            this.tessellator.addVertexWithUV(d12, d13, d15, d8, d10);
            this.tessellator.addVertexWithUV(d11, d13, d15, d4, d6);
        }
    }

    public void renderFaceZPos(double p_147734_2_, double p_147734_4_, double p_147734_6_, TextureAtlasSprite p_147734_8_) {
        double d7;
        if (this.hasOverrideBlockTexture()) {
            p_147734_8_ = this.overrideBlockTexture;
        }
        double d3 = p_147734_8_.func_94214_a(this.renderMinX * 16.0);
        double d4 = p_147734_8_.func_94214_a(this.renderMaxX * 16.0);
        double d5 = p_147734_8_.func_94207_b(16.0 - this.renderMaxY * 16.0);
        double d6 = p_147734_8_.func_94207_b(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = p_147734_8_.func_94209_e();
            d4 = p_147734_8_.func_94212_f();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = p_147734_8_.func_94206_g();
            d6 = p_147734_8_.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateWest == 1) {
            d3 = p_147734_8_.func_94214_a(this.renderMinY * 16.0);
            d6 = p_147734_8_.func_94207_b(16.0 - this.renderMinX * 16.0);
            d4 = p_147734_8_.func_94214_a(this.renderMaxY * 16.0);
            d9 = d5 = (double)p_147734_8_.func_94207_b(16.0 - this.renderMaxX * 16.0);
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateWest == 2) {
            d3 = p_147734_8_.func_94214_a(16.0 - this.renderMaxY * 16.0);
            d5 = p_147734_8_.func_94207_b(this.renderMinX * 16.0);
            d4 = p_147734_8_.func_94214_a(16.0 - this.renderMinY * 16.0);
            d6 = p_147734_8_.func_94207_b(this.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateWest == 3) {
            d3 = p_147734_8_.func_94214_a(16.0 - this.renderMinX * 16.0);
            d4 = p_147734_8_.func_94214_a(16.0 - this.renderMaxX * 16.0);
            d5 = p_147734_8_.func_94207_b(this.renderMaxY * 16.0);
            d6 = p_147734_8_.func_94207_b(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = p_147734_2_ + this.renderMinX;
        double d12 = p_147734_2_ + this.renderMaxX;
        double d13 = p_147734_4_ + this.renderMinY;
        double d14 = p_147734_4_ + this.renderMaxY;
        double d15 = p_147734_6_ + this.renderMaxZ;
        if (this.renderFromInside) {
            d11 = p_147734_2_ + this.renderMaxX;
            d12 = p_147734_2_ + this.renderMinX;
        }
        if (this.enableAO) {
            this.tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            this.tessellator.setBrightness(this.brightnessTopLeft);
            this.tessellator.addVertexWithUV(d11, d14, d15, d3, d5);
            this.tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            this.tessellator.setBrightness(this.brightnessBottomLeft);
            this.tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            this.tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            this.tessellator.setBrightness(this.brightnessBottomRight);
            this.tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            this.tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            this.tessellator.setBrightness(this.brightnessTopRight);
            this.tessellator.addVertexWithUV(d12, d14, d15, d7, d9);
        } else {
            this.tessellator.addVertexWithUV(d11, d14, d15, d3, d5);
            this.tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            this.tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            this.tessellator.addVertexWithUV(d12, d14, d15, d7, d9);
        }
    }

    public void renderFaceXNeg(double p_147798_2_, double p_147798_4_, double p_147798_6_, TextureAtlasSprite p_147798_8_) {
        double d7;
        if (this.hasOverrideBlockTexture()) {
            p_147798_8_ = this.overrideBlockTexture;
        }
        double d3 = p_147798_8_.func_94214_a(this.renderMinZ * 16.0);
        double d4 = p_147798_8_.func_94214_a(this.renderMaxZ * 16.0);
        double d5 = p_147798_8_.func_94207_b(16.0 - this.renderMaxY * 16.0);
        double d6 = p_147798_8_.func_94207_b(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d3 = p_147798_8_.func_94209_e();
            d4 = p_147798_8_.func_94212_f();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = p_147798_8_.func_94206_g();
            d6 = p_147798_8_.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateNorth == 1) {
            d3 = p_147798_8_.func_94214_a(this.renderMinY * 16.0);
            d5 = p_147798_8_.func_94207_b(16.0 - this.renderMaxZ * 16.0);
            d4 = p_147798_8_.func_94214_a(this.renderMaxY * 16.0);
            d6 = p_147798_8_.func_94207_b(16.0 - this.renderMinZ * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateNorth == 2) {
            d3 = p_147798_8_.func_94214_a(16.0 - this.renderMaxY * 16.0);
            d5 = p_147798_8_.func_94207_b(this.renderMinZ * 16.0);
            d4 = p_147798_8_.func_94214_a(16.0 - this.renderMinY * 16.0);
            d6 = p_147798_8_.func_94207_b(this.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateNorth == 3) {
            d3 = p_147798_8_.func_94214_a(16.0 - this.renderMinZ * 16.0);
            d4 = p_147798_8_.func_94214_a(16.0 - this.renderMaxZ * 16.0);
            d5 = p_147798_8_.func_94207_b(this.renderMaxY * 16.0);
            d6 = p_147798_8_.func_94207_b(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = p_147798_2_ + this.renderMinX;
        double d12 = p_147798_4_ + this.renderMinY;
        double d13 = p_147798_4_ + this.renderMaxY;
        double d14 = p_147798_6_ + this.renderMinZ;
        double d15 = p_147798_6_ + this.renderMaxZ;
        if (this.renderFromInside) {
            d14 = p_147798_6_ + this.renderMaxZ;
            d15 = p_147798_6_ + this.renderMinZ;
        }
        if (this.enableAO) {
            this.tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            this.tessellator.setBrightness(this.brightnessTopLeft);
            this.tessellator.addVertexWithUV(d11, d13, d15, d7, d9);
            this.tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            this.tessellator.setBrightness(this.brightnessBottomLeft);
            this.tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            this.tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            this.tessellator.setBrightness(this.brightnessBottomRight);
            this.tessellator.addVertexWithUV(d11, d12, d14, d8, d10);
            this.tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            this.tessellator.setBrightness(this.brightnessTopRight);
            this.tessellator.addVertexWithUV(d11, d12, d15, d4, d6);
        } else {
            this.tessellator.addVertexWithUV(d11, d13, d15, d7, d9);
            this.tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            this.tessellator.addVertexWithUV(d11, d12, d14, d8, d10);
            this.tessellator.addVertexWithUV(d11, d12, d15, d4, d6);
        }
    }

    public void renderFaceXPos(double p_147764_2_, double p_147764_4_, double p_147764_6_, TextureAtlasSprite p_147764_8_) {
        double d7;
        if (this.hasOverrideBlockTexture()) {
            p_147764_8_ = this.overrideBlockTexture;
        }
        double d3 = p_147764_8_.func_94214_a(this.renderMinZ * 16.0);
        double d4 = p_147764_8_.func_94214_a(this.renderMaxZ * 16.0);
        if (this.field_152631_f) {
            d4 = p_147764_8_.func_94214_a((1.0 - this.renderMinZ) * 16.0);
            d3 = p_147764_8_.func_94214_a((1.0 - this.renderMaxZ) * 16.0);
        }
        double d5 = p_147764_8_.func_94207_b(16.0 - this.renderMaxY * 16.0);
        double d6 = p_147764_8_.func_94207_b(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d3 = p_147764_8_.func_94209_e();
            d4 = p_147764_8_.func_94212_f();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = p_147764_8_.func_94206_g();
            d6 = p_147764_8_.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateSouth == 2) {
            d3 = p_147764_8_.func_94214_a(this.renderMinY * 16.0);
            d5 = p_147764_8_.func_94207_b(16.0 - this.renderMinZ * 16.0);
            d4 = p_147764_8_.func_94214_a(this.renderMaxY * 16.0);
            d6 = p_147764_8_.func_94207_b(16.0 - this.renderMaxZ * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateSouth == 1) {
            d3 = p_147764_8_.func_94214_a(16.0 - this.renderMaxY * 16.0);
            d5 = p_147764_8_.func_94207_b(this.renderMaxZ * 16.0);
            d4 = p_147764_8_.func_94214_a(16.0 - this.renderMinY * 16.0);
            d6 = p_147764_8_.func_94207_b(this.renderMinZ * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateSouth == 3) {
            d3 = p_147764_8_.func_94214_a(16.0 - this.renderMinZ * 16.0);
            d4 = p_147764_8_.func_94214_a(16.0 - this.renderMaxZ * 16.0);
            d5 = p_147764_8_.func_94207_b(this.renderMaxY * 16.0);
            d6 = p_147764_8_.func_94207_b(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = p_147764_2_ + this.renderMaxX;
        double d12 = p_147764_4_ + this.renderMinY;
        double d13 = p_147764_4_ + this.renderMaxY;
        double d14 = p_147764_6_ + this.renderMinZ;
        double d15 = p_147764_6_ + this.renderMaxZ;
        if (this.renderFromInside) {
            d14 = p_147764_6_ + this.renderMaxZ;
            d15 = p_147764_6_ + this.renderMinZ;
        }
        if (this.enableAO) {
            this.tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            this.tessellator.setBrightness(this.brightnessTopLeft);
            this.tessellator.addVertexWithUV(d11, d12, d15, d8, d10);
            this.tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            this.tessellator.setBrightness(this.brightnessBottomLeft);
            this.tessellator.addVertexWithUV(d11, d12, d14, d4, d6);
            this.tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            this.tessellator.setBrightness(this.brightnessBottomRight);
            this.tessellator.addVertexWithUV(d11, d13, d14, d7, d9);
            this.tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            this.tessellator.setBrightness(this.brightnessTopRight);
            this.tessellator.addVertexWithUV(d11, d13, d15, d3, d5);
        } else {
            this.tessellator.addVertexWithUV(d11, d12, d15, d8, d10);
            this.tessellator.addVertexWithUV(d11, d12, d14, d4, d6);
            this.tessellator.addVertexWithUV(d11, d13, d14, d7, d9);
            this.tessellator.addVertexWithUV(d11, d13, d15, d3, d5);
        }
    }
}

