/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model;

import com.google.common.collect.ImmutableList;
import elec332.core.client.model.ElecQuadBakery;
import elec332.core.client.model.map.BakedModelRotationMap;
import elec332.core.client.model.map.IBakedModelRotationMap;
import elec332.core.client.model.model.IItemModel;
import elec332.core.client.model.model.IQuadProvider;
import elec332.core.client.model.template.ElecTemplateBakery;
import elec332.core.client.model.template.IModelTemplate;
import elec332.core.client.model.template.IQuadTemplate;
import elec332.core.client.model.template.ITemplateSidedMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class ElecModelBakery {
    protected static final ElecModelBakery instance = new ElecModelBakery();
    private static final List<BakedQuad> EMPTY_LIST = ImmutableList.of();
    private static final ElecQuadBakery quadBakery = ElecQuadBakery.instance;
    private static final IModelTemplate defaultBlockTemplate;
    private static final IModelTemplate defaultItemTemplate;
    public static final ItemCameraTransforms DEFAULT_ITEM;
    public static final ItemCameraTransforms DEFAULT_BLOCK;

    private ElecModelBakery() {
    }

    public IBakedModelRotationMap<IBakedModel> forTemplateRotation(IModelTemplate template) {
        return this.forTemplate(template, false, true);
    }

    public IBakedModelRotationMap<IBakedModel> forTemplate(IModelTemplate template, boolean x, boolean y) {
        BakedModelRotationMap<IBakedModel> ret = new BakedModelRotationMap<IBakedModel>(x, y);
        for (ModelRotation rotation : ModelRotation.values()) {
            if (!ret.isRotationSupported(rotation)) continue;
            ret.setModel(rotation, this.forTemplate(template, rotation));
        }
        return ret;
    }

    public IBakedModel forTemplate(IModelTemplate template) {
        return this.forTemplate(template, null);
    }

    public IBakedModel forTemplate(IModelTemplate template, ModelRotation rotation) {
        return this.forTemplateOverrideQuads(template, rotation, template.getSidedQuads(), template.getGeneralQuads());
    }

    public IBakedModel forTemplateOverrideQuads(IModelTemplate template, @Nullable ITemplateSidedMap sidedQuads, @Nullable List<IQuadTemplate> generalQuads) {
        return this.forTemplateOverrideQuads(template, null, sidedQuads, generalQuads);
    }

    public IBakedModel forTemplateOverrideQuads(IModelTemplate template, ModelRotation rotation, @Nullable ITemplateSidedMap sidedQuads, @Nullable List<IQuadTemplate> generalQuads) {
        if (sidedQuads == null) {
            sidedQuads = ElecTemplateBakery.instance.newQuadSidedMap();
        }
        if (generalQuads == null) {
            generalQuads = ImmutableList.of();
        }
        DefaultBakedModel ret = new DefaultBakedModel(template);
        ret.setGeneralQuads(quadBakery.bakeQuads((List<IQuadTemplate>)generalQuads, (ITransformation)rotation));
        ret.setSidedQuads(quadBakery.bakeQuads(sidedQuads, (ITransformation)rotation));
        return ret;
    }

    public IItemModel itemModelForTextures(TextureAtlasSprite ... textures) {
        return this.itemModelForTextures(defaultItemTemplate, textures);
    }

    public IBakedModel forQuadProvider(IModelTemplate template, final IQuadProvider quadProvider) {
        return new DefaultBakedModel(template){

            @Override
            public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing facing, long rand) {
                return quadProvider.getBakedQuads(state, facing, rand);
            }
        };
    }

    public IItemModel itemModelForTextures(IModelTemplate template, TextureAtlasSprite ... textures) {
        return (IItemModel)((Object)this._forTemplateNoQuadsI(template).setGeneralQuads(quadBakery.getGeneralItemQuads(textures)));
    }

    private BakedItemModel _forTemplateNoQuadsI(IModelTemplate template) {
        return new BakedItemModel(template);
    }

    private static Vector3f applyTranslationScale(Vector3f vec) {
        vec.scale(0.0625f);
        return vec;
    }

    static /* synthetic */ ElecQuadBakery access$200() {
        return quadBakery;
    }

    static /* synthetic */ List access$300() {
        return EMPTY_LIST;
    }

    static {
        DEFAULT_ITEM = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 3.0f, 1.0f)), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 3.0f, 1.0f)), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransformVec3f(new Vector3f(0.0f, -90.0f, 25.0f), ElecModelBakery.applyTranslationScale(new Vector3f(1.13f, 3.2f, 1.13f)), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransformVec3f(new Vector3f(0.0f, -90.0f, 25.0f), ElecModelBakery.applyTranslationScale(new Vector3f(1.13f, 3.2f, 1.13f)), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransformVec3f(new Vector3f(0.0f, 180.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 13.0f, 7.0f)), new Vector3f(1.0f, 1.0f, 1.0f)), ItemTransformVec3f.field_178366_a, new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 2.0f, 0.0f)), new Vector3f(0.5f, 0.5f, 0.5f)), ItemTransformVec3f.field_178366_a);
        DEFAULT_BLOCK = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 2.5f, 0.0f)), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 2.5f, 0.0f)), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(0.0f, 225.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(0.4f, 0.4f, 0.4f)), ItemTransformVec3f.field_178366_a, new ItemTransformVec3f(new Vector3f(30.0f, 225.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(0.625f, 0.625f, 0.625f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 3.0f, 0.0f)), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), ElecModelBakery.applyTranslationScale(new Vector3f(0.0f, 0.0f, 0.0f)), new Vector3f(0.5f, 0.5f, 0.5f)));
        defaultBlockTemplate = ElecTemplateBakery.instance.newDefaultBlockTemplate();
        defaultItemTemplate = ElecTemplateBakery.instance.newDefaultItemTemplate();
    }

    private class DefaultBakedModel
    implements IBakedModel {
        private ElecQuadBakery.ISidedMap sidedQuads = ElecModelBakery.access$200().newSidedMap();
        private List<BakedQuad> generalQuads = ElecModelBakery.access$300();
        private final boolean ao;
        private final boolean gui3D;
        private final boolean builtIn;
        private final TextureAtlasSprite texture;
        private final ItemCameraTransforms ict;

        private DefaultBakedModel(IModelTemplate template) {
            this.ao = template.isAmbientOcclusion();
            this.gui3D = template.isGui3d();
            this.builtIn = template.isBuiltInRenderer();
            this.texture = template.getTexture();
            this.ict = template.getItemCameraTransforms();
        }

        DefaultBakedModel setSidedQuads(@Nonnull ElecQuadBakery.ISidedMap sidedQuads) {
            this.sidedQuads = sidedQuads;
            return this;
        }

        DefaultBakedModel setGeneralQuads(@Nonnull List<BakedQuad> quads) {
            this.generalQuads = quads;
            return this;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing facing, long rand) {
            return facing == null ? this.generalQuads : this.sidedQuads.getForSide(facing);
        }

        public boolean func_177555_b() {
            return this.ao;
        }

        public boolean func_177556_c() {
            return this.gui3D;
        }

        public boolean func_188618_c() {
            return this.builtIn;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.texture;
        }

        public ItemCameraTransforms func_177552_f() {
            return this.ict;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }

    private class BakedItemModel
    extends DefaultBakedModel
    implements IItemModel {
        private BakedItemModel(IModelTemplate template) {
            super(template);
        }
    }
}

