/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.client.IIconRegistrar;
import elec332.core.client.ITextureLoader;
import elec332.core.client.model.ElecModelBakery;
import elec332.core.client.model.ElecQuadBakery;
import elec332.core.client.model.ReplaceJsonEvent;
import elec332.core.client.model.model.IModelAndTextureLoader;
import elec332.core.client.model.model.IModelLoader;
import elec332.core.client.model.template.ElecTemplateBakery;
import elec332.core.client.newstuff.ElecModelHandler;
import elec332.core.client.render.ISpecialBlockRenderer;
import elec332.core.client.render.ISpecialItemRenderer;
import elec332.core.java.ReflectionHelper;
import elec332.core.main.ElecCore;
import elec332.core.util.RegistryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class RenderingRegistry {
    private static final RenderingRegistry instance = new RenderingRegistry();
    public static final int SPECIAL_BLOCK_RENDERER_ID = 39;
    private final Map<Block, ISpecialBlockRenderer> blockRendererMap = Maps.newHashMap();
    private final Map<Item, ISpecialItemRenderer> itemRendererMap = Maps.newHashMap();
    private final List<IModelLoader> modelLoaders = Lists.newArrayList();
    private final List<ITextureLoader> textureLoaders = Lists.newArrayList();
    private final List<Item> extraItems = Lists.newArrayList();
    private final List<Block> extraBlocks = Lists.newArrayList();

    public static RenderingRegistry instance() {
        return instance;
    }

    private RenderingRegistry() {
    }

    public void registerFakeItem(Item item) {
        this.extraItems.add(item);
    }

    public void registerFakeBlock(Block block) {
        this.extraBlocks.add(block);
    }

    public void registerLoader(IModelLoader modelLoader) {
        this.modelLoaders.add(modelLoader);
    }

    public void registerLoader(ITextureLoader textureLoader) {
        this.textureLoaders.add(textureLoader);
    }

    public void registerLoader(IModelAndTextureLoader loader) {
        this.registerLoader((IModelLoader)loader);
        this.registerLoader((ITextureLoader)loader);
    }

    public void registerRenderer(Block block, ISpecialBlockRenderer renderer) {
        if (this.blockRendererMap.containsKey(block)) {
            System.out.println("Replacing renderer for: todo");
        }
        this.blockRendererMap.put(block, renderer);
    }

    public void registerRenderer(Item item, ISpecialItemRenderer renderer) {
        if (this.itemRendererMap.containsKey(item)) {
            System.out.println("Replacing renderer for: todo");
        }
        this.itemRendererMap.put(item, renderer);
    }

    public ISpecialBlockRenderer getRendererFor(Block block) {
        return this.blockRendererMap.get(block);
    }

    public ISpecialItemRenderer getRendererFor(Item item) {
        return this.itemRendererMap.get(item);
    }

    public boolean hasSpecialFirstPersonRenderer(Item item) {
        return this.itemRendererMap.containsKey(item);
    }

    protected void invokeEvent(TextureStitchEvent event) {
        IconRegistrar iconRegistrar = new IconRegistrar(event);
        for (ITextureLoader loader : this.textureLoaders) {
            loader.registerTextures(iconRegistrar);
        }
    }

    protected void invokeEvent(ReplaceJsonEvent event) {
        for (IModelLoader loader : this.modelLoaders) {
            loader.registerModels(event.quadBakery, event.modelBakery, event.templateBakery);
        }
    }

    protected void removeJsonErrors(ModelLoader modelLoader) {
        ElecCore.logger.info("Cleaning up internal Json stuff...");
        try {
            Set set = (Set)ReflectionHelper.makeFinalFieldModifiable(ModelLoader.class.getDeclaredField("missingVariants")).get(modelLoader);
            Map exceptionMap = (Map)ReflectionHelper.makeFinalFieldModifiable(ModelLoader.class.getDeclaredField("loadingExceptions")).get(modelLoader);
            if (ElecCore.removeJSONErrors) {
                exceptionMap.clear();
            }
            HashSet toRemove = Sets.newHashSet();
            HashSet loop = Sets.newHashSet((Iterable)set);
            loop.addAll(exceptionMap.keySet());
            for (ModelResourceLocation rl : this.getValidLocations(loop, (ModelBakery)modelLoader)) {
                set.remove(rl);
                exceptionMap.remove(rl);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ElecCore.logger.info("Finished cleaning up internal Json stuff.");
    }

    protected Set<ModelResourceLocation> getValidLocations(Collection<ModelResourceLocation> loop, ModelBakery modelLoader) {
        IRegistry registry = modelLoader.field_177610_k.field_178128_c.field_174958_a;
        return ElecModelHandler.registerBakedModels((IRegistry<ModelResourceLocation, IBakedModel>)registry);
    }

    public static Iterable<Block> getAllValidBlocks() {
        ArrayList list = Lists.newArrayList((Iterable)RegistryHelper.getBlockRegistry().typeSafeIterable());
        list.addAll(RenderingRegistry.instance.extraBlocks);
        return list;
    }

    public static Iterable<Item> getAllValiditems() {
        ArrayList list = Lists.newArrayList((Iterable)RegistryHelper.getItemRegistry().typeSafeIterable());
        list.addAll(RenderingRegistry.instance.extraItems);
        return list;
    }

    static {
        instance.registerLoader(new IModelAndTextureLoader(){

            @Override
            public void registerModels(ElecQuadBakery quadBakery, ElecModelBakery modelBakery, ElecTemplateBakery templateBakery) {
                for (Item item : RenderingRegistry.getAllValiditems()) {
                    if (!(item instanceof IModelLoader)) continue;
                    ((IModelLoader)item).registerModels(quadBakery, modelBakery, templateBakery);
                }
                for (Block block : RenderingRegistry.getAllValidBlocks()) {
                    if (!(block instanceof IModelLoader)) continue;
                    ((IModelLoader)block).registerModels(quadBakery, modelBakery, templateBakery);
                }
            }

            @Override
            public void registerTextures(IIconRegistrar iconRegistrar) {
                for (Item item : RenderingRegistry.getAllValiditems()) {
                    if (!(item instanceof ITextureLoader)) continue;
                    ((ITextureLoader)item).registerTextures(iconRegistrar);
                }
                for (Block block : RenderingRegistry.getAllValidBlocks()) {
                    if (!(block instanceof ITextureLoader)) continue;
                    ((ITextureLoader)block).registerTextures(iconRegistrar);
                }
            }
        });
    }

    private class IconRegistrar
    implements IIconRegistrar {
        private final TextureMap textureMap;

        public IconRegistrar(TextureStitchEvent event) {
            this.textureMap = event.getMap();
        }

        @Override
        public TextureAtlasSprite registerSprite(ResourceLocation location) {
            this.textureMap.func_174942_a(location);
            return this.textureMap.func_110572_b(location.toString());
        }

        @Override
        public TextureMap getTextureMap() {
            return this.textureMap;
        }
    }
}

