/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.template;

import elec332.core.client.model.template.IModelTemplate;
import elec332.core.client.model.template.IQuadTemplate;
import elec332.core.client.model.template.MutableModelTemplate;
import elec332.core.client.model.template.MutableQuadSidedMap;
import elec332.core.client.model.template.MutableQuadTemplate;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ElecTemplateBakery {
    public static final ElecTemplateBakery instance = new ElecTemplateBakery();

    private ElecTemplateBakery() {
    }

    @Nonnull
    public MutableModelTemplate newDefaultItemTemplate() {
        return MutableModelTemplate.newDefaultItemTemplate();
    }

    @Nonnull
    public MutableModelTemplate newDefaultBlockTemplate(TextureAtlasSprite ... textures) {
        return this.newDefaultBlockTemplate().setSidedQuads(this.newQuadSidedMap(textures));
    }

    @Nonnull
    public MutableModelTemplate newDefaultBlockTemplate(TextureAtlasSprite texture) {
        return this.newDefaultBlockTemplate().setTexture(texture).setSidedQuads(this.newQuadSidedMap(texture));
    }

    @Nonnull
    public MutableModelTemplate newDefaultBlockTemplate() {
        return MutableModelTemplate.newDefaultBlockTemplate();
    }

    @Nonnull
    public MutableModelTemplate newModelTemplate() {
        return MutableModelTemplate.newTemplate();
    }

    @Nonnull
    public MutableModelTemplate copyOf(IModelTemplate template) {
        return MutableModelTemplate.copyOf(template);
    }

    @Nonnull
    public MutableQuadTemplate templateQuadForTexture(EnumFacing side, TextureAtlasSprite texture) {
        return MutableQuadTemplate.templateForTexture(side, texture);
    }

    @Nonnull
    public MutableQuadTemplate newQuadTemplate(EnumFacing side) {
        return MutableQuadTemplate.newTemplate(side);
    }

    @Nonnull
    public MutableQuadTemplate copyOf(IQuadTemplate template) {
        return MutableQuadTemplate.copyOf(template);
    }

    @Nonnull
    public MutableQuadSidedMap newQuadSidedMap() {
        return MutableQuadSidedMap.newQuadSidedMap();
    }

    @Nonnull
    public MutableQuadSidedMap newQuadSidedMap(TextureAtlasSprite texture) {
        MutableQuadSidedMap ret = this.newQuadSidedMap();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            ret.addQuadForSide(facing, this.templateQuadForTexture(facing, texture));
        }
        return ret;
    }

    @Nonnull
    public MutableQuadSidedMap newQuadSidedMap(TextureAtlasSprite ... textures) {
        if (textures.length != EnumFacing.values().length) {
            throw new IllegalArgumentException();
        }
        MutableQuadSidedMap ret = this.newQuadSidedMap();
        for (int i = 0; i < textures.length; ++i) {
            ret.addQuadForSide(EnumFacing.field_82609_l[i], this.templateQuadForTexture(EnumFacing.field_82609_l[i], textures[i]));
        }
        return ret;
    }
}

