/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.newstuff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.api.annotations.ASMDataProcessor;
import elec332.core.api.util.IASMDataHelper;
import elec332.core.api.util.IASMDataProcessor;
import elec332.core.client.model.RenderingRegistry;
import elec332.core.client.newstuff.IBlockModelHandler;
import elec332.core.client.newstuff.IItemModelHandler;
import elec332.core.client.newstuff.IMultipartModelHandler;
import elec332.core.client.newstuff.ModelHandler;
import elec332.core.main.ElecCore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcmultipart.client.multipart.MultipartRegistryClient;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
@ASMDataProcessor(value={LoaderState.PREINITIALIZATION})
public final class ElecModelHandler
implements IASMDataProcessor {
    private static List<IBlockModelHandler> blockModelHandlers;
    private static List<IItemModelHandler> itemModelHandlers;
    private static List<IMultipartModelHandler> multipartModelHandlers;
    private static Map<ModelResourceLocation, IBakedModel> models;
    private static Map<Item, ModelResourceLocation> itemResourceLocations;
    private static Map<IBlockState, ModelResourceLocation> blockResourceLocations;
    private static Map<Pair<IBlockState, IMultipart>, ModelResourceLocation> multipartResourceLocations;
    private static boolean mcmp;

    @Override
    public void processASMData(IASMDataHelper asmData, LoaderState state) {
        for (ASMDataTable.ASMData data : asmData.getAnnotationList(ModelHandler.class)) {
            String s = data.getClassName();
            try {
                Object instance = Class.forName(s).newInstance();
                if (instance instanceof IBlockModelHandler) {
                    blockModelHandlers.add((IBlockModelHandler)instance);
                }
                if (instance instanceof IItemModelHandler) {
                    itemModelHandlers.add((IItemModelHandler)instance);
                }
                if (!(instance instanceof IMultipartModelHandler)) continue;
                multipartModelHandlers.add((IMultipartModelHandler)instance);
            }
            catch (Exception e) {
                throw new RuntimeException("Error registering ModelHandler class: " + s, e);
            }
        }
    }

    public static void registerItemModels(RenderItem renderItem) {
        ElecCore.logger.info("Prehandling Items");
        block0: for (Item item : RenderingRegistry.getAllValiditems()) {
            for (IItemModelHandler handler : itemModelHandlers) {
                if (!handler.handleItem(item)) continue;
                String s = handler.getIdentifier(item);
                final ModelResourceLocation mr = new ModelResourceLocation(item.getRegistryName().toString(), s);
                renderItem.func_175037_a().func_178080_a(item, new ItemMeshDefinition(){

                    public ModelResourceLocation func_178113_a(ItemStack stack) {
                        return mr;
                    }
                });
                itemResourceLocations.put(item, mr);
                continue block0;
            }
        }
    }

    public static void registerBlockModels(ModelManager modelManager) {
        ElecCore.logger.info("Prehandling blocks");
        block0: for (Block block : RenderingRegistry.getAllValidBlocks()) {
            for (final IBlockModelHandler handler : blockModelHandlers) {
                if (!handler.handleBlock(block)) continue;
                modelManager.func_174954_c().func_178120_a().func_178447_a(block, (IStateMapper)new StateMapperBase(){

                    protected ModelResourceLocation func_178132_a(IBlockState state) {
                        ModelResourceLocation mrl = new ModelResourceLocation(state.func_177230_c().getRegistryName().toString() + "#" + handler.getIdentifier(state));
                        blockResourceLocations.put(state, mrl);
                        return mrl;
                    }
                });
                continue block0;
            }
        }
    }

    public static void registerMultiPartModels() {
        if (mcmp) {
            ElecCore.logger.info("Prehandling MultiParts");
            for (final ResourceLocation part : MultipartRegistry.getRegisteredParts()) {
                for (final IMultipartModelHandler handler : multipartModelHandlers) {
                    IMultipart mPart;
                    if (!handler.handlePart(mPart = MultipartRegistry.createPart((ResourceLocation)part, (NBTTagCompound)new NBTTagCompound()))) continue;
                    MultipartRegistryClient.registerSpecialPartStateMapper((ResourceLocation)part, (IStateMapper)new StateMapperBase(){

                        public Map<IBlockState, ModelResourceLocation> func_178130_a(Block blockIn) {
                            for (IBlockState iblockstate : MultipartRegistry.getDefaultState((ResourceLocation)part).func_177619_a()) {
                                this.field_178133_b.put(iblockstate, this.func_178132_a(iblockstate));
                            }
                            return this.field_178133_b;
                        }

                        protected ModelResourceLocation func_178132_a(IBlockState state) {
                            ModelResourceLocation mrl = new ModelResourceLocation(part, handler.getIdentifier(state, mPart));
                            multipartResourceLocations.put(Pair.of((Object)state, (Object)mPart), mrl);
                            return mrl;
                        }
                    });
                }
            }
        }
    }

    public static Set<ModelResourceLocation> registerBakedModels(IRegistry<ModelResourceLocation, IBakedModel> registry) {
        IBakedModel model;
        ModelResourceLocation mrl;
        ElecCore.logger.info("handling models");
        HashSet ret = Sets.newHashSet();
        ArrayList o = Lists.newArrayList();
        IBakedModel missingModel = (IBakedModel)registry.func_82594_a((Object)ModelBakery.field_177604_a);
        block0: for (Map.Entry<IBlockState, ModelResourceLocation> entry : blockResourceLocations.entrySet()) {
            mrl = entry.getValue();
            for (IBlockModelHandler iBlockModelHandler : blockModelHandlers) {
                if (!iBlockModelHandler.handleBlock(entry.getKey().func_177230_c())) continue;
                model = iBlockModelHandler.getModelFor(entry.getKey(), mrl.func_177518_c(), mrl);
                if (model == null) {
                    if (models.get(mrl) != null) continue block0;
                    o.add(mrl);
                    continue block0;
                }
                models.put(mrl, model);
                ret.add(mrl);
                continue block0;
            }
        }
        block2: for (Map.Entry<IBlockState, ModelResourceLocation> entry : itemResourceLocations.entrySet()) {
            mrl = entry.getValue();
            for (IItemModelHandler iItemModelHandler : itemModelHandlers) {
                if (!iItemModelHandler.handleItem((Item)entry.getKey())) continue;
                model = iItemModelHandler.getModelFor((Item)entry.getKey(), mrl.func_177518_c(), mrl);
                if (model == null) {
                    if (models.get(mrl) != null) continue block2;
                    o.add(mrl);
                    continue block2;
                }
                models.put(mrl, model);
                ret.add(mrl);
                continue block2;
            }
        }
        if (mcmp) {
            block4: for (Map.Entry<Object, Object> entry : multipartResourceLocations.entrySet()) {
                mrl = (ModelResourceLocation)entry.getValue();
                for (IMultipartModelHandler iMultipartModelHandler : multipartModelHandlers) {
                    Pair pair;
                    IMultipart multipart;
                    if (!iMultipartModelHandler.handlePart(multipart = (IMultipart)(pair = (Pair)entry.getKey()).getRight())) continue;
                    IBakedModel model2 = iMultipartModelHandler.getModelFor(multipart, (IBlockState)pair.getLeft(), mrl.func_177518_c(), mrl);
                    if (model2 == null) {
                        if (models.get(mrl) != null) continue block4;
                        o.add(mrl);
                        continue block4;
                    }
                    models.put(mrl, model2);
                    ret.add(mrl);
                    continue block4;
                }
            }
        }
        for (ModelResourceLocation modelResourceLocation : o) {
            if (models.get(modelResourceLocation) != null) continue;
            models.put(modelResourceLocation, missingModel);
        }
        for (Map.Entry<Object, Object> entry : models.entrySet()) {
            registry.func_82595_a(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    static {
        mcmp = Loader.isModLoaded((String)"mcmultipart");
        blockModelHandlers = Lists.newArrayList();
        itemModelHandlers = Lists.newArrayList();
        multipartModelHandlers = Lists.newArrayList();
        models = Maps.newHashMap();
        itemResourceLocations = Maps.newHashMap();
        blockResourceLocations = Maps.newHashMap();
        multipartResourceLocations = Maps.newHashMap();
    }
}

