/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.handlers;

import elec332.core.compat.ElecCoreCompatHandler;
import elec332.core.compat.handlers.IWailaCapabilityDataProvider;
import elec332.core.util.RayTraceHelper;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class WailaCompatHandler
implements IWailaDataProvider {
    private static final WailaCompatHandler registry = new WailaCompatHandler();

    private WailaCompatHandler() {
    }

    public static void register(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)registry, IWailaInfoTile.class);
        registrar.registerNBTProvider((IWailaDataProvider)registry, IWailaInfoTile.class);
        CapabilityProvider capabilityProvider = new CapabilityProvider();
        registrar.registerBodyProvider((IWailaDataProvider)capabilityProvider, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)capabilityProvider, TileEntity.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getTileEntity() instanceof IWailaInfoTile) {
            ((IWailaInfoTile)accessor.getTileEntity()).getWailaBody(itemStack, currentTip, accessor, config);
        }
        return currentTip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof IWailaInfoTile && tag != null) {
            return ((IWailaInfoTile)te).getWailaTag(player, te, tag, world, pos);
        }
        return tag;
    }

    public static interface IWailaInfoTile {
        public List<String> getWailaBody(ItemStack var1, List<String> var2, IWailaDataAccessor var3, IWailaConfigHandler var4);

        public NBTTagCompound getWailaTag(EntityPlayerMP var1, TileEntity var2, NBTTagCompound var3, World var4, BlockPos var5);
    }

    private static class CapabilityProvider
    implements IWailaDataProvider {
        private CapabilityProvider() {
        }

        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return null;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return null;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            EnumFacing facing = accessor.getSide();
            TileEntity tile = accessor.getTileEntity();
            if (tile == null) {
                return currenttip;
            }
            for (Map.Entry<Capability, IWailaCapabilityDataProvider> entry : ElecCoreCompatHandler.dataProviders.entrySet()) {
                if (!tile.hasCapability(entry.getKey(), facing)) continue;
                currenttip = entry.getValue().getWailaBody(currenttip, tile.getCapability(entry.getKey(), facing), accessor.getNBTData(), accessor.getPlayer(), accessor.getMOP(), accessor.getWorld(), accessor.getPosition(), accessor.getTileEntity());
            }
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return null;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
            EnumFacing facing = RayTraceHelper.retraceBlock((World)world, (EntityPlayerMP)player, (BlockPos)pos).field_178784_b;
            if (te == null) {
                return tag;
            }
            for (Map.Entry<Capability, IWailaCapabilityDataProvider> entry : ElecCoreCompatHandler.dataProviders.entrySet()) {
                if (!te.hasCapability(entry.getKey(), facing)) continue;
                tag = entry.getValue().getWailaTag(te.getCapability(entry.getKey(), facing), player, te, tag, world, pos);
            }
            return tag;
        }
    }
}

