/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid.basic;

import elec332.core.grid.basic.AbstractGridTile;
import elec332.core.grid.basic.AbstractWorldGridHolder;
import elec332.core.grid.basic.IWiringTypeHelper;
import elec332.core.main.ElecCore;
import elec332.core.registry.AbstractWorldRegistryHolder;
import elec332.core.world.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractCableGrid<G extends AbstractCableGrid<G, T, W, A>, T extends AbstractGridTile<G, T, W, A>, W extends IWiringTypeHelper, A extends AbstractWorldGridHolder<A, G, T, W>> {
    protected final UUID identifier;
    protected final World world;
    protected List<GridData> acceptors = new ArrayList<GridData>();
    protected List<GridData> providers = new ArrayList<GridData>();
    protected List<GridData> specialProviders;
    protected List<GridData> transmitters;
    protected List<BlockPos> locations = new ArrayList<BlockPos>();
    private final AbstractWorldRegistryHolder<A> worldGridHolder;

    public AbstractCableGrid(World world, T p, EnumFacing direction, W wiringHelper, AbstractWorldRegistryHolder<A> worldGridHolder) {
        this.specialProviders = new ArrayList<GridData>();
        this.transmitters = new ArrayList<GridData>();
        this.world = world;
        this.locations.add(((AbstractGridTile)p).getLocation());
        if (wiringHelper.isTransmitter(((AbstractGridTile)p).getTile())) {
            this.transmitters.add(new GridData(((AbstractGridTile)p).getLocation(), direction));
        }
        if (wiringHelper.isSource(((AbstractGridTile)p).getTile()) && wiringHelper.canSourceProvideTo(((AbstractGridTile)p).getTile(), direction)) {
            this.providers.add(new GridData(((AbstractGridTile)p).getLocation(), direction));
        }
        if (wiringHelper.isReceiver(((AbstractGridTile)p).getTile()) && wiringHelper.canReceiverReceiveFrom(((AbstractGridTile)p).getTile(), direction)) {
            this.acceptors.add(new GridData(((AbstractGridTile)p).getLocation(), direction));
        }
        this.identifier = UUID.randomUUID();
        this.worldGridHolder = worldGridHolder;
    }

    public List<BlockPos> getLocations() {
        return this.locations;
    }

    public final G mergeGrids(G grid) {
        if (WorldHelper.getDimID(this.world) != WorldHelper.getDimID(((AbstractCableGrid)grid).world)) {
            throw new RuntimeException();
        }
        if (this.equals(grid)) {
            return (G)this;
        }
        this.uponGridMerge(grid);
        for (BlockPos vec : ((AbstractCableGrid)grid).locations) {
            Object powerTile = ((AbstractWorldGridHolder)this.getWorldHolder()).getPowerTile(vec);
            if (powerTile == null) continue;
            ((AbstractGridTile)powerTile).replaceGrid(grid, (AbstractCableGrid)this);
        }
        ((AbstractWorldGridHolder)this.getWorldHolder()).removeGrid(grid);
        ElecCore.systemPrintDebug("MERGED");
        return (G)this;
    }

    protected void uponGridMerge(G grid) {
        this.locations.addAll(((AbstractCableGrid)grid).locations);
        this.acceptors.addAll(((AbstractCableGrid)grid).acceptors);
        this.providers.addAll(((AbstractCableGrid)grid).providers);
        this.transmitters.addAll(((AbstractCableGrid)grid).transmitters);
        this.specialProviders.addAll(((AbstractCableGrid)grid).specialProviders);
    }

    protected void onTileRemoved(T tile) {
    }

    public abstract void onTick();

    protected A getWorldHolder() {
        return (A)((AbstractWorldGridHolder)this.worldGridHolder.get(this.world));
    }

    protected void invalidate() {
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && ((AbstractCableGrid)obj).identifier.equals(this.identifier);
    }

    public static class GridData {
        private BlockPos loc;
        private EnumFacing direction;

        public GridData(BlockPos blockLoc, EnumFacing direction) {
            this.loc = blockLoc;
            this.direction = direction;
        }

        public BlockPos getLoc() {
            return this.loc;
        }

        public EnumFacing getDirection() {
            return this.direction;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof GridData && ((GridData)obj).loc.equals((Object)this.loc) && ((GridData)obj).direction == this.direction;
        }
    }
}

