/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid.capability;

import elec332.core.grid.capability.ITileData;
import elec332.core.registry.IWorldRegistry;
import elec332.core.world.PositionedObjectHolder;
import elec332.core.world.SurroundingChecker;
import elec332.core.world.WorldHelper;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import mcmultipart.capabilities.MultipartCapabilityHelper;
import mcmultipart.event.PartEvent;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class AbstractWorldGridHolder<T extends ITileData, O>
implements IWorldRegistry,
SurroundingChecker.IFacedSurroundingDataFactory<O>,
SurroundingChecker.ISurroundingHandler<O> {
    protected final World world;
    private final Queue<T> pending;
    private final PositionedObjectHolder<T> registeredTiles;
    private final SurroundingChecker<O> surroundingChecker;

    public AbstractWorldGridHolder(World world) {
        this.world = world;
        this.registeredTiles = new PositionedObjectHolder();
        this.pending = new ArrayDeque<T>();
        this.surroundingChecker = new SurroundingChecker(this, world, this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public final void partAdd(PartEvent.Add event) {
        IMultipart multiPart = event.part;
        if (!multiPart.getWorld().field_72995_K) {
            if (WorldHelper.getDimID(multiPart.getWorld()) != WorldHelper.getDimID(this.world)) {
                return;
            }
            BlockPos pos = multiPart.getPos();
            if (!WorldHelper.chunkLoaded(this.world, pos)) {
                throw new RuntimeException();
            }
            T t = this.getPowerTile(pos);
            TileEntity tile = WorldHelper.getTileAt((IBlockAccess)this.world, pos);
            if (this.isValidTile(tile)) {
                if (t == null) {
                    this.addTile(tile);
                } else {
                    this.resetPosAndSurroundings(pos);
                    this.onExtraMultiPartAdded(t, multiPart);
                }
            }
        }
    }

    @SubscribeEvent
    public final void partRemove(PartEvent.Remove event) {
        IMultipart multiPart = event.part;
        if (!multiPart.getWorld().field_72995_K) {
            if (WorldHelper.getDimID(multiPart.getWorld()) != WorldHelper.getDimID(this.world)) {
                return;
            }
            BlockPos pos = multiPart.getPos();
            T t = this.getPowerTile(pos);
            if (t != null) {
                TileEntity tile = t.getTile();
                if (!this.isValidTile(tile)) {
                    this.removeTile(tile);
                } else {
                    this.resetPosAndSurroundings(pos);
                    this.onMultiPartRemoved(t, multiPart);
                }
            }
        }
    }

    @SubscribeEvent
    public final void chunkUnload(ChunkEvent.Unload event) {
        Collection<T> list;
        ChunkPos chunkPos;
        World world = event.getWorld();
        if (!world.field_72995_K && WorldHelper.getDimID(world) == WorldHelper.getDimID(this.world) && this.registeredTiles.chunkExists(chunkPos = event.getChunk().func_76632_l()) && !(list = this.registeredTiles.getObjectsInChunk(chunkPos).values()).isEmpty()) {
            this.onChunkUnload(list);
        }
    }

    @SubscribeEvent
    public final void chunkLoad(ChunkEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K && WorldHelper.getDimID(world) == WorldHelper.getDimID(this.world)) {
            this.onChunkLoad(event.getChunk().func_177434_r().values());
        }
    }

    public final void addTile(TileEntity tile) {
        if (!tile.func_145831_w().field_72995_K) {
            BlockPos tilePos = tile.func_174877_v();
            if (WorldHelper.getDimID(this.world) != WorldHelper.getDimID(this.world)) {
                throw new IllegalArgumentException();
            }
            if (!WorldHelper.chunkLoaded(this.world, tilePos) || !this.isValidTile(tile)) {
                return;
            }
            if (!this.surroundingChecker.isChange(tilePos)) {
                return;
            }
            if (this.getPowerTile(tilePos) != null) {
                throw new IllegalStateException();
            }
            T powerTile = this.generate(tile);
            this.registeredTiles.put(powerTile, tilePos);
            this.surroundingChecker.addPosition(tilePos);
            this.resetPosAndSurroundings(tilePos);
            this.add(powerTile);
        }
    }

    public final void removeTile(TileEntity tile) {
        if (!tile.func_145831_w().field_72995_K) {
            this.removeTile_(this.getPowerTile(tile.func_174877_v()));
        }
    }

    private void removeTile_(T t) {
        this.remove(t);
        this.removeFromRegistry(t);
    }

    private void resetPosAndSurroundings(BlockPos pos) {
        this.surroundingChecker.resetPositionData(pos);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos o = pos.func_177972_a(facing);
            if (this.getPowerTile(o) == null) continue;
            this.surroundingChecker.resetPositionData(o);
        }
    }

    protected abstract boolean isValidTile(TileEntity var1);

    protected abstract T generate(TileEntity var1);

    protected abstract void add(T var1);

    protected abstract void onExtraMultiPartAdded(T var1, IMultipart var2);

    protected void onChunkLoad(Collection<TileEntity> loadingTiles) {
        for (TileEntity tile : loadingTiles) {
            this.addTile(tile);
        }
    }

    protected abstract void remove(T var1);

    protected abstract void onMultiPartRemoved(T var1, IMultipart var2);

    protected abstract void onChunkUnload(Collection<T> var1);

    protected abstract void onTick();

    public abstract void invalidate();

    @Override
    public final void onWorldUnload() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.invalidate();
    }

    @Override
    public final void tick() {
        if (!this.pending.isEmpty()) {
            ITileData t = (ITileData)this.pending.poll();
            while (t != null) {
                this.add(t);
                t = (ITileData)this.pending.poll();
            }
        }
        this.onTick();
    }

    public final T getPowerTile(BlockPos pos) {
        return (T)((ITileData)this.registeredTiles.get(pos));
    }

    public void removeFromRegistry(T t) {
        this.registeredTiles.remove(t.getPos());
        this.surroundingChecker.removePosition(t.getPos());
    }

    public final void addPendingAdd(T t) {
        this.pending.add(t);
    }

    public static ICapabilityProvider forSlottedProvider(final IMultipartContainer provider) {
        return new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return MultipartCapabilityHelper.hasCapability((IMultipartContainer)provider, capability, (EnumFacing)facing);
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)MultipartCapabilityHelper.getCapability((IMultipartContainer)provider, capability, (EnumFacing)facing);
            }
        };
    }
}

