/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid.v2;

import com.google.common.collect.Sets;
import elec332.core.grid.v2.ITileEntityLink;
import elec332.core.world.DimensionCoordinate;
import elec332.core.world.PositionedObjectHolder;
import elec332.core.world.WorldHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public abstract class AbstractGridHandler<T extends ITileEntityLink> {
    protected final Int2ObjectMap<PositionedObjectHolder<T>> objects = new Int2ObjectArrayMap();
    protected final Set<DimensionCoordinate> extraUnload = Sets.newHashSet();
    protected final Set<DimensionCoordinate> changeCheck = Sets.newHashSet();
    protected final Set<DimensionCoordinate> add = Sets.newHashSet();

    public void checkNotifyStuff(Set<DimensionCoordinate> updates) {
        for (DimensionCoordinate dimCoord : updates) {
            T o = this.getObject(dimCoord);
            if (o == null) continue;
            TileEntity tile = dimCoord.getTileEntity();
            if (tile == null) {
                if (o != null) {
                    this.extraUnload.add(dimCoord);
                }
                return;
            }
            if (!o.getPosition().isLoaded()) {
                throw new IllegalStateException();
            }
            if (!o.hasChanged()) continue;
            this.changeCheck.add(dimCoord);
            return;
        }
    }

    public void checkBlockUpdates(Set<DimensionCoordinate> updates) {
        for (DimensionCoordinate dimCoord : updates) {
            TileEntity tile = dimCoord.getTileEntity();
            T o = this.getObject(dimCoord);
            if (o == null && tile == null) {
                return;
            }
            if (o == null && this.isValidObject(tile)) {
                this.add.add(dimCoord);
            }
            if (o != null && tile == null) {
                this.extraUnload.add(dimCoord);
            }
            if (o == null || !this.isValidObject(tile) || !o.hasChanged()) continue;
            this.changeCheck.add(dimCoord);
        }
    }

    public void worldUnload(World world) {
        PositionedObjectHolder worldObjects = (PositionedObjectHolder)this.objects.get(WorldHelper.getDimID(world));
        if (worldObjects != null) {
            HashSet unload = Sets.newHashSet();
            for (ChunkPos chunkPos : worldObjects.getChunks()) {
                for (ITileEntityLink o : worldObjects.getObjectsInChunk(chunkPos).values()) {
                    unload.add(o.getPosition());
                }
            }
            this.unloadObjects_Internal(unload);
        }
    }

    public void checkChunkUnload(Set<DimensionCoordinate> updates) {
        updates.addAll(this.extraUnload);
        updates.addAll(this.changeCheck);
        this.unloadObjects_Internal(updates);
        this.extraUnload.clear();
    }

    protected void unloadObjects_Internal(Set<DimensionCoordinate> updates) {
        Set<DimensionCoordinate> updates_ = Collections.unmodifiableSet(updates);
        for (DimensionCoordinate dimCoord : updates) {
            T o = this.getObject(dimCoord);
            if (o == null) {
                System.out.println("????_-3");
                continue;
            }
            this.onObjectRemoved(o, updates_);
            this.removeObject(dimCoord);
        }
    }

    protected abstract void onObjectRemoved(T var1, Set<DimensionCoordinate> var2);

    public void checkChunkLoad(Set<DimensionCoordinate> updates) {
        HashSet oldUpdates = Sets.newHashSet(updates);
        updates.addAll(this.add);
        updates.addAll(this.changeCheck);
        for (DimensionCoordinate dimCoord : updates) {
            TileEntity tile = dimCoord.getTileEntity();
            if (tile == null || !this.isValidObject(tile)) continue;
            T o = this.getObject(dimCoord);
            if (o != null) {
                if (oldUpdates.contains(dimCoord)) {
                    throw new IllegalStateException();
                }
            } else {
                o = this.createNewObject(tile);
                ((PositionedObjectHolder)this.objects.get(WorldHelper.getDimID(tile.func_145831_w()))).put(o, tile.func_174877_v());
                o.hasChanged();
            }
            this.internalAdd(o);
        }
        this.add.clear();
        this.changeCheck.clear();
    }

    protected abstract void internalAdd(T var1);

    public abstract void tick();

    public abstract boolean isValidObject(TileEntity var1);

    protected abstract T createNewObject(TileEntity var1);

    protected void removeObject(DimensionCoordinate dimensionCoordinate) {
        this.getDim(dimensionCoordinate).remove(dimensionCoordinate.getPos());
    }

    protected T getObject(DimensionCoordinate dimensionCoordinate) {
        return (T)((ITileEntityLink)this.getDim(dimensionCoordinate).get(dimensionCoordinate.getPos()));
    }

    protected PositionedObjectHolder<T> getDim(DimensionCoordinate dimensionCoordinate) {
        PositionedObjectHolder ret = (PositionedObjectHolder)this.objects.get(dimensionCoordinate.getDimension());
        if (ret == null) {
            ret = new PositionedObjectHolder();
            this.objects.put(dimensionCoordinate.getDimension(), ret);
        }
        return ret;
    }
}

