/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid.v2;

import elec332.core.grid.v2.ITileEntityLink;
import elec332.core.world.DimensionCoordinate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class DefaultTileEntityLink
implements ITileEntityLink {
    protected final TileEntity tile;
    protected final DimensionCoordinate coord;

    protected DefaultTileEntityLink(TileEntity tile) {
        this.tile = tile;
        this.coord = DimensionCoordinate.fromTileEntity(tile);
    }

    @Override
    @Nullable
    public TileEntity getTileEntity() {
        return this.tile;
    }

    @Override
    @Nonnull
    public DimensionCoordinate getPosition() {
        return this.coord;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.hasCachedCapability(capability, facing) || this.coord.isLoaded() && this.tile != null && this.tile.hasCapability(capability, facing);
    }

    protected boolean hasCachedCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return false;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T t = this.getCachedCapability(capability, facing);
        if (t != null) {
            return t;
        }
        if (this.tile == null) {
            return null;
        }
        return (T)this.tile.getCapability(capability, facing);
    }

    @Nullable
    public <T> T getCachedCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return null;
    }
}

