/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.tooltip;

import com.google.common.collect.Lists;
import elec332.core.client.render.GuiDraw;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ToolTip {
    private final List<ColouredString> tooltip;

    public ToolTip() {
        this((ColouredString)null);
    }

    public ToolTip(ColouredString colouredString) {
        this(Lists.newArrayList((Object[])new ColouredString[]{colouredString}));
    }

    public ToolTip(List<ColouredString> s) {
        this.tooltip = s;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(int mouseX, int mouseY, int guiLeft, int guiTop) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        if (!this.tooltip.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int k = 0;
            for (ColouredString colouredString : this.tooltip) {
                int l = fontRenderer.func_78256_a(colouredString.toString());
                if (l <= k) continue;
                k = l;
            }
            int j2 = mouseX + 12 - guiLeft;
            int k2 = mouseY - 12 - guiTop;
            int i1 = 8;
            if (this.tooltip.size() > 1) {
                i1 += 2 + (this.tooltip.size() - 1) * 10;
            }
            if (j2 + k > guiLeft) {
                j2 -= 28 + k;
            }
            if (k2 + i1 + 6 > guiTop) {
                k2 = guiTop - i1 - 6;
            }
            int j1 = -267386864;
            GuiDraw.drawGradientRect(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            GuiDraw.drawGradientRect(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            GuiDraw.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            GuiDraw.drawGradientRect(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            GuiDraw.drawGradientRect(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            GuiDraw.drawGradientRect(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            GuiDraw.drawGradientRect(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            GuiDraw.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            GuiDraw.drawGradientRect(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < this.tooltip.size(); ++i2) {
                String s1 = this.tooltip.get(i2).toString();
                fontRenderer.func_175063_a(s1, (float)j2, (float)k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
        }
    }

    public static class ColouredString {
        private final String string;

        public ColouredString(String s) {
            this(TextFormatting.GRAY, s);
        }

        public ColouredString(TextFormatting colour, String s) {
            this.string = colour + s;
        }

        public String toString() {
            return this.string;
        }
    }
}

