/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget;

import com.google.common.collect.Lists;
import elec332.core.client.RenderHelper;
import elec332.core.inventory.IWidgetContainer;
import elec332.core.inventory.tooltip.ToolTip;
import elec332.core.main.ElecCore;
import elec332.core.network.PacketSyncWidget;
import elec332.core.network.PacketWidgetDataToServer;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Widget {
    private IWidgetContainer container;
    private int id;
    public final int x;
    public final int y;
    public final int u;
    public final int v;
    public final int width;
    public final int height;
    private boolean hidden;

    public Widget(int x, int y, int u, int v, int width, int height) {
        this.x = x;
        this.y = y;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
    }

    public final Widget setContainer(IWidgetContainer container) {
        this.container = container;
        return this;
    }

    public final Widget setID(int id) {
        this.id = id;
        return this;
    }

    public void initWidget(IContainerListener iCrafting) {
        this.detectAndSendChanges(Lists.newArrayList((Object[])new IContainerListener[]{iCrafting}));
    }

    public void detectAndSendChanges(List<IContainerListener> crafters) {
    }

    public void sendProgressBarUpdate(List<IContainerListener> crafters, int value) {
        for (IContainerListener iCrafting : crafters) {
            iCrafting.func_71112_a((Container)this.container, this.id, value);
        }
    }

    public void sendProgressBarUpdate(IContainerListener iCrafting, int value) {
        iCrafting.func_71112_a((Container)this.container, this.id, value);
    }

    public void updateProgressbar(int value) {
    }

    public final void sendNBTChangesToPlayer(EntityPlayerMP player, NBTTagCompound tagCompound) {
        ElecCore.networkHandler.getNetworkWrapper().sendTo((IMessage)new PacketSyncWidget(tagCompound, this.container, this), player);
    }

    public final void sendNBTChangesToServer(NBTTagCompound tagCompound) {
        ElecCore.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketWidgetDataToServer(tagCompound, this.container, this));
    }

    public final void readNBTChangesFromPacket(NBTTagCompound tagCompound, Side receiver) {
        if (receiver == Side.CLIENT) {
            this.readNBTChangesFromPacket(tagCompound);
        } else {
            this.readNBTChangesFromPacketServerSide(tagCompound);
        }
    }

    public void readNBTChangesFromPacket(NBTTagCompound tagCompound) {
    }

    public void readNBTChangesFromPacketServerSide(NBTTagCompound tagCompound) {
    }

    public final boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x - 1 && mouseX < this.x + this.width + 1 && mouseY >= this.y - 1 && mouseY < this.y + this.height + 1;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Gui gui, int guiX, int guiY, int mouseX, int mouseY) {
        gui.func_73729_b(guiX + this.x, guiY + this.y, this.u, this.v, this.width, this.height);
    }

    @SideOnly(value=Side.CLIENT)
    protected void bindTexture(ResourceLocation resourceLocation) {
        RenderHelper.bindTexture(resourceLocation);
    }

    public Widget setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public ToolTip getToolTip() {
        return null;
    }

    protected boolean nullityDiffers(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null;
    }
}

