/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import elec332.core.inventory.widget.WidgetButton;
import java.util.List;
import javax.annotation.Nullable;

public class WidgetEnumChange<E extends Enum>
extends WidgetButton {
    private final Class<E> enumClass;
    private List<IEnumChangedEvent<WidgetEnumChange<E>>> list;
    private int index;
    private Predicate<E> predicate;

    public WidgetEnumChange(int x, int y, int width, int height, Class<E> clazz, Predicate<E> predicate) {
        this(x, y, width, height, clazz);
        this.predicate = predicate;
    }

    public WidgetEnumChange(int x, int y, int width, int height, Class<E> clazz) {
        super(x, y, 0, 0, width, height);
        this.enumClass = clazz;
        this.index = 0;
        this.list = Lists.newArrayList();
        this.setDisplayString(((Enum)this.getEnum()).toString());
        this.predicate = new Predicate<E>(){

            public boolean apply(@Nullable E input) {
                return true;
            }
        };
    }

    public WidgetEnumChange<E> addButtonEvent(IEnumChangedEvent<WidgetEnumChange<E>> event) {
        this.list.add(event);
        return this;
    }

    public E getEnum() {
        return (E)((Enum[])this.enumClass.getEnumConstants())[this.index];
    }

    public void setEnum(E e) {
        if (!this.predicate.apply(e)) {
            return;
        }
        boolean b = true;
        for (int i = 0; i < ((Enum[])this.enumClass.getEnumConstants()).length; ++i) {
            Enum en = ((Enum[])this.enumClass.getEnumConstants())[i];
            if (e != en) continue;
            this.setDisplayString(en.toString());
            this.index = i;
            b = false;
        }
        this.distributeEvents();
        if (b) {
            throw new IllegalArgumentException();
        }
    }

    public WidgetEnumChange<E> setPredicate(Predicate<E> predicate) {
        this.predicate = predicate;
        this.checkPredicate();
        return this;
    }

    @Override
    public void onButtonClicked() {
        this.nextIdx();
        while (!this.predicate.apply(this.getEnum())) {
            this.nextIdx();
        }
        this.setDisplayString(((Enum)this.getEnum()).toString());
        super.onButtonClicked();
        this.distributeEvents();
    }

    private void nextIdx() {
        ++this.index;
        if (this.index >= ((Enum[])this.enumClass.getEnumConstants()).length) {
            this.index = 0;
        }
    }

    private void checkPredicate() {
        boolean b = false;
        for (Enum e : (Enum[])this.enumClass.getEnumConstants()) {
            if (!this.predicate.apply((Object)e)) continue;
            b = true;
            break;
        }
        if (!b) {
            throw new IllegalStateException();
        }
    }

    private void distributeEvents() {
        for (IEnumChangedEvent<WidgetEnumChange<WidgetEnumChange>> iEnumChangedEvent : this.list) {
            iEnumChangedEvent.onEnumChanged(this);
        }
    }

    public static interface IEnumChangedEvent<E extends WidgetEnumChange> {
        public void onEnumChanged(E var1);
    }
}

