/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget;

import elec332.core.inventory.IHasProgressBar;
import elec332.core.inventory.widget.Widget;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.util.ResourceLocation;

public class WidgetProgressArrow
extends Widget {
    private boolean right;
    private final IHasProgressBar iHasProgressBar;
    private int lastProgress;

    public WidgetProgressArrow(int x, int y, IHasProgressBar iHasProgressBar, boolean right) {
        super(x, y, 0, 0, 23, 16);
        this.iHasProgressBar = iHasProgressBar;
        this.right = right;
    }

    @Override
    public void detectAndSendChanges(List<IContainerListener> crafters) {
        int progress = this.iHasProgressBar.getProgress();
        if (this.lastProgress != progress) {
            this.sendProgressBarUpdate(crafters, progress);
            this.lastProgress = progress;
        }
    }

    @Override
    public void updateProgressbar(int value) {
        this.lastProgress = value;
    }

    @Override
    public void draw(Gui gui, int guiX, int guiY, int mouseX, int mouseY) {
        float progress = this.iHasProgressBar.getProgressScaled(this.lastProgress);
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        if (progress < 0.0f) {
            progress = 0.0f;
        }
        this.bindTexture(new ResourceLocation("eleccore", "progressbars.png"));
        int fullArrow = (int)(23.0f * progress);
        if (this.right) {
            gui.func_73729_b(guiX + this.x, guiY + this.y, 0, 0, this.width, this.height);
            gui.func_73729_b(guiX + this.x, guiY + this.y, 0, 16, fullArrow, this.height);
        } else {
            gui.func_73729_b(guiX + this.x, guiY + this.y, 23, 16, this.width, this.height);
            gui.func_73729_b(guiX + this.x, guiY + this.y, 23, 0, 23 - fullArrow, this.height);
        }
    }
}

