/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.item;

import elec332.core.client.IIconRegistrar;
import elec332.core.client.model.ElecModelBakery;
import elec332.core.client.model.ElecQuadBakery;
import elec332.core.client.model.INoJsonItem;
import elec332.core.client.model.template.ElecTemplateBakery;
import elec332.core.item.AbstractItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractTexturedItem
extends AbstractItem
implements INoJsonItem {
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] textures;
    @SideOnly(value=Side.CLIENT)
    private IBakedModel model;

    public AbstractTexturedItem(ResourceLocation rl) {
        super(rl);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel getItemModel(ItemStack stack, World world, EntityLivingBase entity) {
        return this.model;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ElecQuadBakery quadBakery, ElecModelBakery modelBakery, ElecTemplateBakery templateBakery) {
        this.model = modelBakery.itemModelForTextures(this.textures);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures(IIconRegistrar iconRegistrar) {
        ResourceLocation[] tl = this.getTextureLocations();
        this.textures = new TextureAtlasSprite[tl.length];
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = iconRegistrar.registerSprite(tl[i]);
        }
    }

    protected ResourceLocation[] getTextureLocations() {
        return new ResourceLocation[]{this.getTextureLocation()};
    }

    protected ResourceLocation getTextureLocation() {
        return new ResourceLocation(this.getRegistryName().func_110624_b(), "items/" + this.getRegistryName().func_110623_a());
    }
}

