/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.main;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.api.util.IASMDataHelper;
import elec332.core.api.util.IASMDataProcessor;
import elec332.core.compat.ElecCoreCompatHandler;
import elec332.core.effects.AbilityHandler;
import elec332.core.grid.v2.internal.GridEventHandler;
import elec332.core.grid.v2.internal.GridEventInputHandler;
import elec332.core.handler.TickHandler;
import elec332.core.network.NetworkHandler;
import elec332.core.network.PacketReRenderBlock;
import elec332.core.network.PacketSyncWidget;
import elec332.core.network.PacketTileDataToServer;
import elec332.core.network.PacketWidgetDataToServer;
import elec332.core.proxies.CommonProxy;
import elec332.core.server.ServerHelper;
import elec332.core.util.FileHelper;
import elec332.core.util.LoadTimer;
import elec332.core.util.MCModInfo;
import elec332.core.util.OredictHelper;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="ElecCore", name="ElecCore", dependencies="required-after:Forge@[12.16.0.1832,);after:forestry;", acceptedMinecraftVersions="[1.9,)", version="1.5.311", useMetadata=true)
public class ElecCore {
    public static final String ElecCoreVersion = "1.5.311";
    public static final String MODID = "ElecCore";
    public static final String MODNAME = "ElecCore";
    @SidedProxy(clientSide="elec332.core.proxies.ClientProxy", serverSide="elec332.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="ElecCore")
    public static ElecCore instance;
    public static TickHandler tickHandler;
    public static NetworkHandler networkHandler;
    public static ElecCoreCompatHandler compatHandler;
    public static Logger logger;
    private static ASMDataTable dataTable;
    private ASMDataProcessor asmDataProcessor;
    private Configuration config;
    private LoadTimer loadTimer;
    public static final boolean developmentEnvironment;
    @Deprecated
    public static boolean oldBlocks;
    public static boolean debug;
    public static boolean removeJSONErrors;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.loadTimer = new LoadTimer(logger, "ElecCore");
        this.loadTimer.startPhase((FMLStateEvent)event);
        this.config = new Configuration(FileHelper.getConfigFileElec(event));
        tickHandler = new TickHandler();
        networkHandler = new NetworkHandler("ElecCore");
        networkHandler.registerClientPacket(PacketSyncWidget.class);
        networkHandler.registerServerPacket(PacketTileDataToServer.class);
        networkHandler.registerServerPacket(PacketWidgetDataToServer.class);
        networkHandler.registerClientPacket(PacketReRenderBlock.class);
        compatHandler = new ElecCoreCompatHandler(this.config, logger);
        dataTable = event.getAsmData();
        this.asmDataProcessor = new ASMDataProcessor();
        this.asmDataProcessor.init();
        MinecraftForge.EVENT_BUS.register((Object)tickHandler);
        debug = this.config.getBoolean("debug", "general", false, "Set to true to print debug info to the log.");
        removeJSONErrors = this.config.getBoolean("removeJsonExceptions", "client", true, "Set to true to remove all the Json model errors from the log.") && !developmentEnvironment;
        ServerHelper.instance.load();
        MinecraftForge.EVENT_BUS.register((Object)new GridEventHandler());
        proxy.preInitRendering();
        this.asmDataProcessor.process(LoaderState.PREINITIALIZATION);
        this.loadTimer.endPhase((FMLStateEvent)event);
        MCModInfo.createMCModInfoElec(event, "Provides core functionality for Elec's Mods", "-", "assets/elec332/logo.png", new String[]{"Elec332"});
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.loadTimer.startPhase((FMLStateEvent)event);
        this.config.load();
        if (this.config.hasChanged()) {
            this.config.save();
        }
        compatHandler.init();
        AbilityHandler.instance.init();
        this.asmDataProcessor.process(LoaderState.INITIALIZATION);
        OredictHelper.initLists();
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.loadTimer.startPhase((FMLStateEvent)event);
        this.asmDataProcessor.process(LoaderState.POSTINITIALIZATION);
        OredictHelper.initLists();
        proxy.postInitRendering();
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.loadTimer.startPhase((FMLStateEvent)event);
        this.asmDataProcessor.process(LoaderState.AVAILABLE);
        OredictHelper.initLists();
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerAboutToStartEvent event) {
        GridEventInputHandler.INSTANCE.reloadHandlers();
    }

    public static void systemPrintDebug(Object s) {
        if (debug) {
            System.out.println(s);
        }
    }

    static {
        oldBlocks = true;
        debug = false;
        removeJSONErrors = true;
        developmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    private class ASMDataProcessor {
        private final Map<LoaderState, List<IASMDataProcessor>> asmLoaderMap = Maps.newHashMap();
        private final List<LoaderState> validStates = ImmutableList.of((Object)LoaderState.PREINITIALIZATION, (Object)LoaderState.INITIALIZATION, (Object)LoaderState.POSTINITIALIZATION, (Object)LoaderState.AVAILABLE);
        private IASMDataHelper asmDataHelper;

        private ASMDataProcessor() {
        }

        private void init() {
            for (LoaderState state : this.validStates) {
                this.asmLoaderMap.put(state, Lists.newArrayList());
            }
            this.asmDataHelper = new IASMDataHelper(){

                @Override
                public ASMDataTable getASMDataTable() {
                    return dataTable;
                }

                @Override
                public Set<ASMDataTable.ASMData> getAnnotationList(Class<? extends Annotation> annotationClass) {
                    return this.getASMDataTable().getAll(annotationClass.getName());
                }
            };
            for (ASMDataTable.ASMData data : this.asmDataHelper.getAnnotationList(elec332.core.api.annotations.ASMDataProcessor.class)) {
                IASMDataProcessor dataProcessor;
                try {
                    dataProcessor = (IASMDataProcessor)Class.forName(data.getClassName()).newInstance();
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error invocating annotated IASMData class: " + data.getClassName());
                }
                elec332.core.api.annotations.ASMDataProcessor annotation = dataProcessor.getClass().getAnnotation(elec332.core.api.annotations.ASMDataProcessor.class);
                LoaderState[] hS = annotation.value();
                if (hS == null || hS.length == 0) {
                    throw new IllegalArgumentException("Invalid LoaderState parameters: Null or empty array; For " + data.getClassName());
                }
                for (LoaderState state : hS) {
                    if (!this.validStates.contains(state)) {
                        throw new IllegalArgumentException("Invalid LoaderState parameter: " + state + "; For " + data.getClassName());
                    }
                    this.asmLoaderMap.get(state).add(dataProcessor);
                }
            }
        }

        private void process(LoaderState state) {
            if (this.validStates.contains(state)) {
                List<IASMDataProcessor> dataProcessors = this.asmLoaderMap.get(state);
                for (IASMDataProcessor dataProcessor : dataProcessors) {
                    dataProcessor.processASMData(this.asmDataHelper, state);
                }
            } else {
                throw new IllegalArgumentException();
            }
            this.asmLoaderMap.remove(state);
        }
    }
}

