/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.main;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import elec332.core.grid.v2.AbstractGridHandler;
import java.util.Collections;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public final class ElecCoreRegistrar {
    public static final Registry<AbstractGridHandler> GRIDS_V2;
    private static final Predicate IN_MOD_LOADING;

    private ElecCoreRegistrar() {
        throw new IllegalAccessError();
    }

    static {
        IN_MOD_LOADING = input -> !Loader.instance().hasReachedState(LoaderState.AVAILABLE);
        GRIDS_V2 = new Registry(IN_MOD_LOADING);
    }

    public static class Registry<T> {
        private final Set<T> type = Sets.newHashSet();
        private final Set<T> immutableSet = Collections.unmodifiableSet(this.type);
        private final Predicate<T> predicate;

        private Registry() {
            this(Predicates.alwaysTrue());
        }

        private Registry(Predicate<T> predicate) {
            this.predicate = predicate;
        }

        public boolean register(T t) {
            return this.predicate.apply(t) && this.type.add(t);
        }

        public Set<T> getAllRegisteredObjects() {
            return this.immutableSet;
        }
    }
}

