/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.module;

import com.google.common.collect.ImmutableList;
import elec332.core.module.annotations.ElecModule;
import elec332.core.module.annotations.ModuleProxy;
import elec332.core.module.event.SetupModuleEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ModuleHandler {
    private List<Object> registeredModules = new ArrayList<Object>();
    private Configuration mainConfig;

    public ModuleHandler(Configuration config) {
        this.mainConfig = config;
    }

    public void registerModule(Object object) {
        this.registeredModules.add(object);
    }

    public void preInit(FMLPreInitializationEvent event) {
        ArrayList<Object> validModules = new ArrayList<Object>();
        for (Object object : this.registeredModules) {
            ElecModule objAnnotation;
            Class<?> objClass = object.getClass();
            if (!objClass.isAnnotationPresent(ElecModule.class) || !this.mainConfig.get("Modules", (objAnnotation = objClass.getAnnotation(ElecModule.class)).name(), objAnnotation.enabled()).getBoolean()) continue;
            validModules.add(object);
            this.injectProxy(object, FMLCommonHandler.instance().getSide());
        }
        this.registeredModules.clear();
        this.registeredModules = ImmutableList.copyOf(validModules);
        SetupModuleEvent setupModuleEvent = new SetupModuleEvent(this.mainConfig);
        for (Object object : this.registeredModules) {
            ElecModule moduleAnnotation = object.getClass().getAnnotation(ElecModule.class);
            this.invokeEvent(object, setupModuleEvent.forModule(moduleAnnotation.name()));
        }
        FMLPreInitializationEvent fMLPreInitializationEvent = new FMLPreInitializationEvent(new Object[]{null, event.getModConfigurationDirectory()});
        for (Object object : this.registeredModules) {
            ElecModule moduleAnnotation = object.getClass().getAnnotation(ElecModule.class);
            ModMetadata moduleMeta = new ModMetadata();
            moduleMeta.version = event.getModMetadata().version;
            moduleMeta.modId = moduleAnnotation.name();
            moduleMeta.name = moduleAnnotation.name();
            fMLPreInitializationEvent.applyModContainer((ModContainer)new DummyModContainer(moduleMeta));
            this.invokeEvent(object, fMLPreInitializationEvent);
        }
    }

    public void init(FMLInitializationEvent event) {
        this.invokeForAll(event);
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.invokeForAll(event);
    }

    private void invokeForAll(Object event) {
        for (Object object : this.registeredModules) {
            this.invokeEvent(object, event);
        }
    }

    private void injectProxy(Object module, Side side) {
        for (Field field : module.getClass().getFields()) {
            if (!field.isAnnotationPresent(ModuleProxy.class)) continue;
            try {
                ModuleProxy moduleProxy = field.getAnnotation(ModuleProxy.class);
                String className = side.isClient() ? moduleProxy.clientSide() : moduleProxy.serverSide();
                Object newProxy = Class.forName(className).newInstance();
                if (!field.getClass().isAssignableFrom(newProxy.getClass())) continue;
                field.set(module, newProxy);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void invokeEvent(Object object, Object event) {
        Class<?> objClass = object.getClass();
        for (Method method : objClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ElecModule.EventHandler.class) && !method.isAnnotationPresent(Mod.EventHandler.class)) continue;
            try {
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(event.getClass())) continue;
                method.invoke(object, event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

